import java.io.*;
import java.util.*;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.imageio.*;

import javax.swing.*;
import javax.swing.event.*;

import java.lang.Math;
public class yjkconv {
	BufferedImage loadimage(File f) throws Throwable {
		//try { 
		return ImageIO.read(f);
		//} catch (Exception e) { System.err.println("IMAGEIO.read: " + e); } return null;
	}
	void saveimage(BufferedImage img, File f, String type) {
		try { ImageIO.write(img, type, f); } catch (Exception e) { System.err.println("IMAGEIO.write: " + e); }
	}
	
	public static void main(String args[]) { 
		try {
			new yjkconv().main2(args);
		} catch (Throwable e) {
			JOptionPane.showMessageDialog(null, e);
		}

	}
	
	class framelauncher implements Runnable {
		int w,h; frame f;
		public void run() {

			cimg ci = new cimg(w, h);
			
			JScrollPane scroll = new JScrollPane();
			scroll.setVerticalScrollBarPolicy(scroll.VERTICAL_SCROLLBAR_ALWAYS);
			scroll.setHorizontalScrollBarPolicy(scroll.HORIZONTAL_SCROLLBAR_ALWAYS);
			scroll.getViewport().add(ci);
			scroll.getViewport().setScrollMode(JViewport.SIMPLE_SCROLL_MODE);

			f = new frame(); f.framescr = ci; 
			f.addKeyListener(ci);
	
			f.add(scroll); //f.add(ci); 
			f.resize(850,750); //f.pack(); 
			f.show(); f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		}
	}
	
	public class frame extends JFrame {
		public cimg framescr;
	}

	
	public class cimg extends JPanel implements KeyListener {
		
		public void	keyPressed(KeyEvent e) {
		}//        Invoked when a key has been pressed.
		public void	keyReleased(KeyEvent e) { /*showbitmap = false; repaint();*/ }//          Invoked when a key has been released.
		public void	keyTyped(KeyEvent e) {}//          Invoked when a key has been typed.

		BufferedImage img;
		int w() { return img.getWidth(); }
		int h() { return img.getHeight(); }
		int zw() { return img.getWidth() * zoom; }
		int zh() { return img.getHeight() * zoom; }
		int zoom = 3;
		
		public cimg(int w, int h) {
			img = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
		}
		
		int forcebar = 0; //force scrollbar
		public Dimension getMinimumSize() { return new Dimension(zw() + forcebar, zh() + forcebar); }
		public Dimension getPreferredSize() { return new Dimension(zw() + forcebar, zh() + forcebar); }
		public Dimension getMaximumSize() { return new Dimension(zw() + forcebar, zh() + forcebar); }
		
		//need .getViewport().setScrollMode(JViewport.SIMPLE_SCROLL_MODE);
		public void paint(Graphics g) {
			super.paint(g);
			Container c = getParent();
			JViewport v = (JViewport)c;
			JScrollPane s = (JScrollPane)v.getParent();
			
			int barx = s.getHorizontalScrollBar().getValue();
			int x = barx / zoom;

			g.drawImage(img, 0,0,zw(),zh(), null);
		}
	}
	

	//______________________________________________________
	
	int cmd_smear = 0;
	int cmd_wait = 0;
	
	String[] commandline(String a[]) {
		Vector v = new Vector();
		int i = 0;
		while (i < a.length) {
			if (a[i].equals("-smear")) {
				i++; cmd_smear = Integer.parseInt(a[i++]);
				continue;
			}
			if (a[i].equals("-wait")) {
				i++; cmd_wait = Integer.parseInt(a[i++]);
				continue;
			}
			v.add(a[i++]);
		}
		String b[] = new String[v.size()];
		for (i = 0; i < v.size(); i++) {
			b[i] = (String)(v.get(i));
		}
		return b;
	}
	
	BufferedImage srcimg;
	
	public void main2(String args[]) throws Throwable {
		args = commandline(args);
		
		String name;
		if (args.length > 0) {
			name = args[0];
		} else {
			JFileChooser dia = new JFileChooser("file");
			dia.setCurrentDirectory(new File("."));
			int result = dia.showOpenDialog(null);
			name = ""+dia.getSelectedFile();
		}
		int w = 256; int h = 212;		

		framelauncher f = new framelauncher(); 
		f.w = w; f.h = h;
		f.run();
		gui = f.f.framescr;

		String bname = "";

		for (int lace = 0; lace <= 1; lace++) {

		File file = new File(name);
		srcimg = loadimage(file);
		f.f.setTitle(file.getName());
		
		//trilinear part
		while((srcimg.getWidth() > (w*2))||(srcimg.getHeight() > (h*2))) {
			int sw = srcimg.getWidth();
			int sh = srcimg.getHeight();
			BufferedImage tmpimg = new BufferedImage(sw/2, sh/2, BufferedImage.TYPE_INT_RGB);
			Graphics2D g = tmpimg.createGraphics();
			g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
			g.drawImage(srcimg,0,0,sw/2,sh/2,null);
			srcimg = tmpimg;
		}

		int sw = srcimg.getWidth();
		int sh = srcimg.getHeight();
		if (sw > w) { sh = sh * w / sw; sw = w; }
		if (sh > h) { sw = sw * h / sh; sh = h; }


		BufferedImage tmpimg = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
		Graphics2D g = tmpimg.createGraphics();
		g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
		
		int cropw = w - sw;
		int croph = h - sh;
		g.drawImage(srcimg,lace*2+cropw/2,croph/2,sw,sh,null);
		g.setColor(Color.black);
		g.fillRect(w-2+lace*2,0,2,h);
		srcimg = tmpimg;
		
		int i;
		yjk = new int[h][];
		for (i = 0; i < h; i++) yjk[i] = new int[w];
		guirgb = new int[h][];
		for (i = 0; i < h; i++) guirgb[i] = new int[w];
		rgb = new int[h][];
		for (i = 0; i < h; i++) rgb[i] = new int[w];		
		ga = new int[256];
		for (i = 0; i < 256; i++) ga[i] = ga(i);
		
		//testfill(); show();
		convert2();
		
		if (lace == 0)	{ bname = name+".s12"; }
		else		{ bname = name+".12s"; }
		
		bsave(bname); //System.err.println(""+bname);
		}
		
		if (args.length == 0) 
			JOptionPane.showMessageDialog(null, "BSAVED: "+bname);
		else {
			try { Thread.sleep(cmd_wait); } catch (Exception e) {}
			System.exit(0);
		}
	}
	
	void show() {
		for (int y = 0; y < yjk.length; y++) {
			yjk2rgb(y); line2gui(y);
		}
	}
	
	void writew(OutputStream o, int n) throws Exception {
		o.write((byte)(n % 256)); o.write((byte)(n >> 8));
	}
	void bsave(String name) {
		File f = new File(name);
		try {
		FileOutputStream o = new FileOutputStream(f);

		int length = 256 * 212;
		o.write(0xfe); 
		writew(o, 0); 
		writew(o, 0 + length - 1);
		writew(o, 0);	
		
		
		for (int y = 0; y < 212; y++) {
			for (int x = 0; x < 256; x++) {
				o.write((byte)yjk[y][x]);
			}
		}
		
		o.close();
		
		} catch (Exception e) {
			System.err.println("bsave:"+e);
		}
	}
	
	
	//______________________________________________________
	int ga[];
	
	int yjk[][]; //bigger than bytes to get java unsigned
	int rgb[][]; //for the pic
	int guirgb[][]; //array to show in window

	cimg gui;
	void line2gui(int y) {
		for(int x = 0; x < yjk[0].length; x++) {
			gui.img.setRGB(x,y,guirgb[y][x]);
		}
		gui.repaint();
	}
	
	static final int clip(int n) {
		if (n < 0) return 0;
		if (n > 31) return 31;
		return n;
	}
	static final int clip255(int n) {
		if (n < 0) return 0;
		if (n > 255) return 255;
		return n;
	}
	
	class RGB { int r; int g; int b; }
	
	//y j k variables are shifted like in bytes of VDP
	static final void yjk2rgb(int y, int jl, int jh, int kl, int kh, RGB rgb) {
			//int Y = (y & 0xF0) >> 3;
			int Y = (y & 0xF8) >> 3; //5 bit in notpaletted
			
			int J = (jl & 7) + (jh & 3) * 8 - (jh & 4) * 8;
			int K = (kl & 7) + (kh & 3) * 8 - (kh & 4) * 8;
				
			rgb.r = clip((Y + J)                  ) * 8;
			rgb.g = clip((Y + K)                  ) * 8;
			rgb.b = clip(((5 * Y - 2 * J - K) / 4)) * 8;		
	}

	//used for display
	void yjk2rgb(int y) {
		RGB rgb = new RGB();
		
		for(int x = 0; x < yjk[0].length; x+=4) {
			
			//J seems to be high word
			int jl = yjk[y][x+2];
			int jh = yjk[y][x+3];
			int kl = yjk[y][x+0];
			int kh = yjk[y][x+1];

			
			for(int x2 = 0; x2 <= 3; x2++) {
				//beware big Y vs small y variables
				int Y = yjk[y][x+x2];
				yjk2rgb(Y, jl, jh, kl, kh, rgb);
				guirgb[y][x+x2] = rgb.r * 65536 + rgb.g * 256 + rgb.b;
			}
		}
	}
	
	//_________________________________________________________________________
	void convert() {
		//load pic to rgb array
		for(int y = 0; y < yjk.length; y++) {
			for(int x = 0; x < yjk[0].length; x++) {
				rgb[y][x] = srcimg.getRGB(x,y);
			}
		}
		
		//convert
		for(int y = 0; y < yjk.length; y++) {
			
			for (int x = 0; x < yjk[0].length; x+=4) {
				convertblock(x,y);
			}
			
			//for display in window
			yjk2rgb(y); 
			line2gui(y);
		}
		
	}
	
	
	//convert 4x1 pixels. x must be 4-aligned.
	void convertblock(int x, int y) {
		boolean isgray = true;
		for (int i = 0; i < 4; i++) {
			int r = (rgb[y][x+i] >> 16)&0xFF;
			int g = (rgb[y][x+i] >>  8)&0xFF;
			int b = (rgb[y][x+i] >>  0)&0xFF;
			
			//having troubles reaching white when acellerating grayscale
			//only acellerating black
			
			if (!((r==0)&&(g==0)&&(b==0))) { isgray = false; break; }
			//if (!((r==g)&&(g==b))) {
			//	isgray = false; break;
			//}
		}
		
		int fjl = 0; int fjh = 0; int fkl = 0; int fkh = 0;
		RGB col = new RGB(); //used as temporary deep in functions, allocate here for speed.


		if (!isgray) {
		int founderr = 0x7fffffff;
		
		for (int jl = 0; jl <= 7; jl +=1) {
		for (int jh = 0; jh <= 7; jh +=1) {
		for (int kl = 0; kl <= 7; kl +=1) {
		for (int kh = 0; kh <= 7; kh +=1) {
			int err = errblock(x,y,jl,jh,kl,kh,col);
			if (err < founderr) {
				founderr = err;
				fjl = jl; fjh = jh; fkl = kl; fkh = kh;
			}
		}}}}
		} //if grayflag
	
		// store JK in array
		// J seems to be high byte
		yjk[y][x+2] = fjl;
		yjk[y][x+3] = fjh;
		yjk[y][x+0] = fkl;
		yjk[y][x+1] = fkh;

		
		// store Y in array, matching to already given JK
		for (int x2 = 0; x2 < 4; x2++) {
			yjk[y][x+x2] |= findpixelY(x+x2,y, fjl, fjh, fkl, fkh, col);
		}

	}
	
	
	//error in 4x1 pixels when using best fitting Y
	int errblock(int x, int y, int jl, int jh, int kl, int kh, RGB col) {
		int sumerr = 0;
		for (int x2 = 0; x2 < 4; x2++) {
			findpixelY(x+x2, y, jl, jh, kl, kh, col);
			sumerr += col.r;
		}
		return sumerr;
	}
	
	static final int abs(int n) { if (n < 0) return -n; return n; }
	static final double abs(double n) { if (n < 0) return -n; return n; }

	int ga(int n) {
		double d = n / 255.0;
		d = Math.pow(d, 2.2);
		return (int)(d * 255.0);
	}
	
	//find the best fitting Y of a pixel given a particular JK
	//return Y in VDP format. error var returned in rgb.r
	int findpixelY(int x, int y, int jl, int jh, int kl, int kh, RGB col) {
		int founderr = 0x7fffffff;
		int foundy = 0;

		int r = (rgb[y][x] >> 16)&0xFF;
		int g = (rgb[y][x] >>  8)&0xFF;
		int b = (rgb[y][x] >>  0)&0xFF;
		
		//todo make an yjk2rgb that has effect with Y+=4 to have one more bit in Y. for dithering.
		for (int Y = 0; Y < 256; Y+=8) {	//slide Y in VDP format. 5bit in not paletted
			yjk2rgb(Y, jl, jh, kl, kh, col);
			int err = 0;
			
			//the rgb rating was needed in the huge jk find
			//in plain Y find it still plays a role, because some Y slides change color much.
			
			//rgb squares difference
			err +=    (r - col.r)*(r - col.r)
				+ (g - col.g)*(g - col.g)
				+ (b - col.b)*(b - col.b);
			
			//brightness error
			int err2 = ((ga[r]*299+ga[g]*587+ga[b]*114)-(ga[col.r]*299+ga[col.g]*587+ga[col.b]*114));

			err2 = err2 * 3;	//emphasize factor brightness error over rgb error

			err2 = err2 / 333;	// 1/333: the err2 got *1000, the err summing r,g,b got *3
			err += err2 * err2;	//brightness error too go squared
			
			if (err < founderr) {
				founderr = err;
				foundy = Y;
			}
		}
		col.r = founderr;
		return foundy;
	}
	
	
	//_____________________________________________________________________
	

	//a more precise way to get Y, doing a search
	void linemakeY(int y) {
		RGB col = new RGB();
		for (int x = 0; x < yjk[0].length; x+=4) {
			int jl,jh,kl,kh;
			//J seems to be high word
			kl = yjk[y][x+0] & 7;
			kh = yjk[y][x+1] & 7;		
			jl = yjk[y][x+2] & 7;
			jh = yjk[y][x+3] & 7;
			
			// store Y in array, matching to already given JK
			for (int x2 = x; x2 < (x + 4); x2++) {
				yjk[y][x2] = (yjk[y][x2] & 0x7) | findpixelY(x2,y, jl, jh, kl, kh, col);
			}
		}	
	}
	
	void convert2() {
		//load pic to rgb array
		for(int y = 0; y < yjk.length; y++) {
			for(int x = 0; x < yjk[0].length; x++) {
				rgb[y][x] = srcimg.getRGB(x,y);
			}
		}
		
		//convert
		for(int y = 0; y < yjk.length; y++) {
			
			for (int x = 0; x < yjk[0].length; x+=4) {
				convertblock2(x,y);
			}
			
			linemakeY(y); //linemakeYfast(y); 
			
			//for display in window
			yjk2rgb(y); 
			line2gui(y);
		}
		
	}
	//convert 4x1 pixels. x must be 4-aligned.
	void convertblock2(int x, int y) {
		RGB col = new RGB(); //used as temporary deep in functions, allocate here for speed.

		int r = 0, g = 0, b = 0;
		int n = 0;
		int i;

		int d = cmd_smear;
		for (i = (0-d); i <= (3+d); i++) {
			try {
				r += (rgb[y][x+i] >> 16)&0xFF; g += (rgb[y][x+i] >>  8)&0xFF; b += (rgb[y][x+i] >>  0)&0xFF; n++;
			} catch (ArrayIndexOutOfBoundsException e) { }		
		}
		
		//normalize sum
		r = r / n; g = g / n; b = b / n;
		
		//rounding here seems ok. but not really an effect.
		//r = clip255(r + 0x04) & 0xF8;
		//g = clip255(g + 0x04) & 0xF8;
		//b = clip255(b + 0x04) & 0xF8;
		
		int j = 0; 
		int k = 0;
		
		//J=R-Y,  K=G-Y,  Y=B/2+R/4+G/8

		//j = r/8 - b/8;
		//k = g/8;
		int tmpY = b/2 + r/4 + g/8;
		
		j = r - tmpY;
		k = g - tmpY;
		
		//rounding here seems to ditch color a bit
		//j = (j + 0x04) >> 3; //+0x04 : rounding
		//k = (k + 0x04) >> 3; //+0x04 : rounding
		//j = (j + (((y ^ (x/4)    )&1) * 0x04)) >> 3; //jk dither
		//k = (k + (((y ^ (x/4) ^ 1)&1) * 0x04)) >> 3; //jk dither
		j >>= 3;
		k >>= 3;

		
		int jl = j & 7;
		int jh = (j >> 3) & 7;
		int kl = k & 7;
		int kh = (k >> 3) & 7;			
		yjk[y][x+0] = kl;
		yjk[y][x+1] = kh;		
		yjk[y][x+2] = jl;
		yjk[y][x+3] = jh;
		
		//direct make Y by formula
		for (i = 0; i <= 3; i++) {
			r = (rgb[y][x+i] >> 16)&0xFF; g = (rgb[y][x+i] >>  8)&0xFF; b = (rgb[y][x+i] >>  0)&0xFF; n++;
			int Y = b/2 + r/4 + g/8;
			Y = Y + ((i^y) & 1) * 0x04; //dithering	//Y = Y + 0x04;	//rounding
			yjk[y][x+i] |= Y & 0xF8;
		}
	}

	//_____________________________________________________________________
	void convert3() {
		//load pic to rgb array
		for(int y = 0; y < yjk.length; y++) {
			for(int x = 0; x < yjk[0].length; x++) {
				rgb[y][x] = srcimg.getRGB(x,y);
			}
		}
		
		//convert
		for(int y = 0; y < yjk.length; y++) {
			
			for (int x = 0; x < yjk[0].length; x+=4) {
				blockmakeJK(x,y);
			}
			convertline3(y);
			linemakeY(y);
			
			//for display in window
			yjk2rgb(y); 
			line2gui(y);
		}
		
	}
	
	void blockmakeJK(int x, int y) {
		RGB col = new RGB(); //used as temporary deep in functions, allocate here for speed.

		int r = 0, g = 0, b = 0;
		int n = 0;
		int i;
		
		i = 0;
		try {
			r += (rgb[y][x+i] >> 16)&0xFF; g += (rgb[y][x+i] >>  8)&0xFF; b += (rgb[y][x+i] >>  0)&0xFF; n++;
		} catch (ArrayIndexOutOfBoundsException e) { }
		
		i = 1;
		try {
			r += (rgb[y][x+i] >> 16)&0xFF; g += (rgb[y][x+i] >>  8)&0xFF; b += (rgb[y][x+i] >>  0)&0xFF; n++;
		} catch (ArrayIndexOutOfBoundsException e) { }
		
		i = 2;
		try {
			r += (rgb[y][x+i] >> 16)&0xFF; g += (rgb[y][x+i] >>  8)&0xFF; b += (rgb[y][x+i] >>  0)&0xFF; n++;
		} catch (ArrayIndexOutOfBoundsException e) { }		
		
		i = 3;
		try {
			r += (rgb[y][x+i] >> 16)&0xFF; g += (rgb[y][x+i] >>  8)&0xFF; b += (rgb[y][x+i] >>  0)&0xFF; n++;
		} catch (ArrayIndexOutOfBoundsException e) { }

		//normalize sum. result is 8bit.
		r = r / n; g = g / n; b = b / n;

		int j,k;
		
		//"portar doc" : J=R-Y,  K=G-Y,  Y=B/2+R/4+G/8
		int tmpY = b/2 + r/4 + g/8;
		j = r - tmpY;
		k = g - tmpY;
		
		//8bit to 5bit. unclear why not 6bit.
		j >>= 3; k >>= 3;

		yjk[y][x+0] = (yjk[y][x+0] & 0xC0) | (k      & 7);
		yjk[y][x+1] = (yjk[y][x+1] & 0xC0) | ((k>>3) & 7);		
		yjk[y][x+2] = (yjk[y][x+2] & 0xC0) | (j      & 7);
		yjk[y][x+3] = (yjk[y][x+3] & 0xC0) | ((j>>3) & 7);
	}
	
	double statej, statek;
	double md = 4;
		
	//convert 4x1 pixels. x must be 4-aligned.
	void convertline3(int y) {
		statej = 32; statek = 0;

		for (int x = 0; x < yjk[0].length; x +=4 ) {
			int j = (yjk[y][x+2] & 7) + (yjk[y][x+3] & 7)*8;
			int k = (yjk[y][x+0] & 7) + (yjk[y][x+1] & 7)*8;
			j ^=32; k ^= 32; //normalize
			
			double dj = j - statej;
			double dk = k - statek;
			double d = abs(dj) + abs(dk);
			double f = 1;
			if (d > md) f = md/d;
			
			dj *= f; dk *= f;

			statej += dj; statek += dk;
			
			j = (int)statej; k = (int)statek;
			
			j ^=32; k ^= 32; //normalize
			yjk[y][x+0] = (yjk[y][x+0] & 0xC0) | (k      & 7);
			yjk[y][x+1] = (yjk[y][x+1] & 0xC0) | ((k>>3) & 7);		
			yjk[y][x+2] = (yjk[y][x+2] & 0xC0) | (j      & 7);
			yjk[y][x+3] = (yjk[y][x+3] & 0xC0) | ((j>>3) & 7);
		}
	}
	
	
	//___________________________ OLD / TEST codes
	void testfill() {
		try {
			
		int n = 0;

		for (int j  = 0; j <= 7;  j++)   {
		for (int jl = 0; jl <= 7; jl+=4) {
		for (int k  = 0; k <= 7;  k++)   {
		for (int kl = 0; kl <= 7; kl+=1) {
				
		for (int y = 0; y <= 15; y += 4) {
			//XOR 4 shows linear space
			k = k ^ 4; j = j ^ 4;
			yjk[n/256][(n+y+0)%256] = (y+0)*16+(kl&0x7);
			yjk[n/256][(n+y+1)%256] = (y+1)*16+(k &0x7);
			yjk[n/256][(n+y+2)%256] = (y+2)*16+(jl&0x7);
			yjk[n/256][(n+y+3)%256] = (y+3)*16+(j &0x7);
			k = k ^ 4; j = j ^ 4;
		}
		n = n + 256; if (n >= (256*64)) { n = n - (256*64) + 1*16; }
		}}}}
		
		} catch (Exception e) {
			System.err.println("testfill:" + e);
		}
	}

	void oldtestfill() { //false swapped names of J K like in BASIC example.
		try {
			
		int n = 0;
		
		for (int j  = 0; j <= 7;  j++)   {
		for (int jl = 0; jl <= 7; jl+=4) {
		for (int k  = 0; k <= 7;  k++)   {
		for (int kl = 0; kl <= 7; kl+=2) {
		for (int y = 0; y <= 15; y += 4) {
			yjk[n/256][(n+y+0)%256] = (y+0)*16+kl;
			yjk[n/256][(n+y+1)%256] = (y+1)*16+k;
			yjk[n/256][(n+y+2)%256] = (y+2)*16+jl;
			yjk[n/256][(n+y+3)%256] = (y+3)*16+j;
			
		}
		n = n + 512; if (n >= (256*128)) { n = n - (256*128) + 2*16; }
		}}}}
		
		} catch (Exception e) {
			System.err.println("testfill:" + e);
		}
	}
	
	void OLDyjk2rgb(int y) {
		for(int x = 0; x < yjk[0].length; x+=4) {
			int J = (yjk[y][x+2] & 7) + (yjk[y][x+3] & 3) * 8 - (yjk[y][x+3] & 4) * 8;
			int K = (yjk[y][x+0] & 7) + (yjk[y][x+1] & 3) * 8 - (yjk[y][x+1] & 4) * 8;
			
			for(int x2 = 0; x2 <= 3; x2++) {
				//beware big Y vs small y variables
				int Y = (yjk[y][x+x2] & 0xF0) >> 3;
				
				int r = clip((Y + J)                  ) * 8;
				int g = clip((Y + K)                  ) * 8;
				int b = clip(((5 * Y - 2 * J - K) / 4)) * 8;
				
				guirgb[y][x+x2] = r * 65536 + g * 256 + b;
			}
		}
	}
	
	//imprecise and with some overflow bug.
	void linemakeYfast(int y) {
		for (int x = 0; x < yjk[0].length; x+=4) {
			int k = (yjk[y][x+0] & 7) + (yjk[y][x+1] & 7) * 8;

			//K = G - Y -> Y = G - K
			
			for (int x2 = x; x2 < (x + 4); x2++) {
				int g = (rgb[y][x2]>>8)&0xFF;
				g >>= 3; //similar shift as j k in 8bit->VDP
				int Y = g - k;
				
				yjk[y][x2] = (yjk[y][x2] & 0x7) | (Y * 8);
			}
		}	
	}
}
