/*
 * RoboPlay for MSX
 * Copyright (C) 2020 by RoboSoft Inc.
 *
 * amd.h
 *
 * AMD: AMUSIC Adlib Tracker player
 */

#ifndef __AMD_H
#define __AMD_H

#define AMD_TOTAL_HEADER_SIZE 1072

#define AMD_HEADER_SONG_NAME 0
#define AMD_HEADER_AUTHOR    24
#define AMD_INSTRUMENT_DATA  48

#define AMD_HEADER_ID        1062
#define AMD_HEADER_VERSION   1071

typedef struct 
{
    char    name[23];
    uint8_t data[11];
} AMD_INSTRUMENT;

typedef struct
{
    char song_name[24];
    char author[24];

    AMD_INSTRUMENT instruments[26];

    uint8_t length;
    uint8_t number_of_patterns;
    uint8_t order[128];

    uint8_t id[9];
    uint8_t version;

    uint8_t* track_data; 
} AMD_HEADER;

#endif /* __AMD_H */