/*
 * RoboPlay for MSX
 * Copyright (C) 2020 by RoboSoft Inc.
 *
 * dos2.h
 */

#ifndef  __DOS2_H
#define  __DOS2_H

#include <stdint.h>

/* standard descriptors */
#define  STDIN   0
#define  STDOUT  1
#define  STDERR  2
#define  AUX     3
#define  PRN     4

/* open/creat flags */
#define  O_RDONLY   0x01
#define  O_WRONLY   0x02
#define  O_RDWR     0x00
#define  O_INHERIT  0x04

/* creat attributes */
#define  ATTR_RDONLY  0x01
#define  ATTR_HIDDEN  0x02
#define  ATTR_SYSTEM  0x04
#define  ATTR_VOLUME  0x08
#define  ATTR_FOLDER  0x10
#define  ATTR_ARCHIV  0x20
#define  ATTR_DEVICE  0x80

/* seek whence */
#define  SEEK_SET  0
#define  SEEK_CUR  1
#define  SEEK_END  2

/* MSX_DOS error codes */
#define __INTER 0xDF    /* Internal error */
#define _NORAM  0xDE    /* Not Enough Memory */
#define __IBDOS 0xDC    /* Invalid MSX-DOS Call */  
#define __IDRV  0xDB    /* Invalid drive */
#define __IFNM  0xDA    /* Invalid filename */ 
#define __IPATH 0xD9    /* Invalid pathname  */
#define __PLONG 0xD8    /* Pathname too long */
#define __NOFIL 0xD7    /* File not found */
#define __NODIR 0xD6    /* Directory not found  */
#define __DRFUL 0xD5    /* Root directory full */
#define __DKFUL 0xD4    /* Disk full */
#define __DUPF  0xD3    /* Duplicate filename  */
#define __DIRE  0xD2    /* Invalid directory move */
#define __FILRO 0xD1    /* Read only file */
#define __DINE  0xD0    /* Directory not empty */
#define __IATTR 0xCF    /* Invalid attributes */
#define __DOT   0xCE    /* Invalid . or .. operation */
#define __SYSX  0xCD    /* System file exists */
#define __DIRX  0xCC    /* Directory exists */
#define __FILEX 0xCB    /* File exists */
#define __FOPEN 0xCA    /* File already in use  */
#define __OV64K 0xC9    /* Cannot transfer above 64K */
#define __FILE  0xC8    /* File allocation error */
#define __EOF   0xC7    /* End of file  */
#define __ACCV  0xC6    /* File access violation  */
#define __IPROC 0xC5    /* Invalid process id  */
#define __NHAND 0xC4    /* No spare file handles */
#define __IHAND 0xC3    /* Invalid file handle */
#define __NOPEN 0xC2    /* File handle not open */
#define __IDEV  0xC1    /* Invalid device operation */
#define __IENV  0xC0    /* Invalid environment string */
#define __ELONG 0xBF    /* Environment string too long */
#define __IDATE 0xBE    /* Invalid date */
#define _ITIME  0xBD    /* Invalid time */
#define __RAMDX 0xBC    /* RAM disk (drive H:) already exists */
#define __NRAMD 0xBB    /* RAM disk does not exist */
#define __HDEAD 0xBA    /* File handle has been deleted */
#define __ISBFN 0xB8    /* Invalid sub-function number */

extern uint8_t  dos2_file_info_block[64];
extern uint8_t  dos2_last_error;

extern int8_t   dos2_open(char *, uint8_t);
extern int8_t   dos2_creat(char *, uint8_t, uint8_t);
extern int8_t   dos2_close(int8_t);
extern int8_t   dos2_dup(int8_t);
extern int16_t  dos2_read(int8_t, void *, int16_t);
extern int16_t  dos2_write(int8_t, void *, int16_t);
extern uint32_t dos2_lseek(int8_t, uint32_t, uint8_t);
extern void     dos2_exit(int8_t);

extern int8_t   dos2_find_first_entry(char *);
extern int8_t   dos2_find_next_entry();

#endif /* __DOS2_H */