;
; RoboPlay for MSX
; Copyright (C) 2020 by RoboSoft Inc.
;
; dos2.s
;

	.area _DATA

_dos2_file_info_block::
	.db 0xFF	; Always 0xFF
	.ds 13		; Filename
	.ds 2		; File attributes
	.ds 2		; Time of last modification
	.ds 2		; Date of last modification
	.ds 2		; Start cluster
	.ds 4		; File size
	.ds 1		; Logical drive
	.ds 37		; Internal information


_dos2_last_error::
	.ds 1


	.area _CODE


_dos2_open::
	push ix
	ld ix,#0
	add ix,sp

	; path
	ld e,4(ix)
	ld d,5(ix)
	; flags
	ld a,6(ix)
	; call
	ld c,#0x43
	call 5
	; check error
	ld (_dos2_last_error),a
	add a,#0
	jp z,_open_ok
	ld l,#-1
	jp _open_end
_open_ok:
	ld l,b
_open_end:

	pop ix
	ret



_dos2_creat::
	push ix
	ld ix,#0
	add ix,sp

	; path
	ld e,4(ix)
	ld d,5(ix)
	; flags
	ld a,6(ix)
	; attrib
	ld b,7(ix)
	; call
	ld c,#0x44
	call 5
	; check error
	ld (_dos2_last_error),a
	add a,#0
	jp z,_creat_ok
	ld l,#-1
	jp _creat_end
_creat_ok:
	ld l,b
_creat_end:

	pop ix
	ret



_dos2_close::
	push ix
	ld ix,#0
	add ix,sp

	; handle
	ld b,4(ix)
	; call
	ld c,#0x45
	call 5
	; return
	ld (_dos2_last_error),a
	ld l,a

	pop ix
	ret



_dos2_dup::
	push ix
	ld ix,#0
	add ix,sp

	; handle
	ld b,4(ix)
	; call
	ld c,#0x47
	call 5
	; return
	ld (_dos2_last_error),a
	add a,#0
	jp z,_dup_ok
	ld l,#-1
	jp _dup_end
_dup_ok:
	ld l,b
_dup_end:

	pop ix
	ret	



_dos2_read::
	push ix
	ld ix,#0
	add ix,sp

	; handle
	ld b,4(ix)
	; buffer
	ld e,5(ix)
	ld d,6(ix)
	; bytes
	ld l,7(ix)
	ld h,8(ix)
	; call
	ld c,#0x48
	call 5
	; return
	ld (_dos2_last_error),a
	add a,#0
	jp z,_read_end
	ld h,#-1
	ld l,#-1
_read_end:

	pop ix
	ret



_dos2_write::
	push ix
	ld ix,#0
	add ix,sp

	; handle
	ld b,4(ix)
	; buffer
	ld e,5(ix)
	ld d,6(ix)
	; bytes
	ld l,7(ix)
	ld h,8(ix)
	; call
	ld c,#0x49
	call 5
	; return
	ld (_dos2_last_error),a
	add a,#0
	jp z,_write_end
	ld h,#-1
	ld l,#-1
_write_end:

	pop ix
	ret



_dos2_lseek::
	push ix
	ld ix,#0
	add ix,sp

	; handle
	ld b,4(ix)
	; offset (32bit)
	ld l,5(ix)
	ld h,6(ix)
	ld e,7(ix)
	ld d,8(ix)
	; method
	ld a,9(ix)
	; call
	ld c,#0x4A
	call 5
	; return
	ld (_dos2_last_error),a
	add a,#0
	jp z,_lseek_end
	ld h,#-1
	ld l,#-1
_lseek_end:

	pop ix
	ret



_dos2_exit::
	push ix
	ld ix,#0
	add ix,sp

	ld b,4(ix)
	ld c,#0x62
	call 5

	pop ix
	ret


_dos2_find_first_entry::
	push ix
	ld ix,#0
	add ix,sp

	; file name
	ld e,4(ix)
	ld d,5(ix)
    ld ix,#_dos2_file_info_block
    ld b,#0

    ld c,#0x40
    call 5

	; return
	ld (_dos2_last_error),a
	ld l,a

	pop ix
	ret


_dos2_find_next_entry::
	push ix

	ld ix,#_dos2_file_info_block

	ld c,#0x41
	call 5

	; return
	ld (_dos2_last_error),a
	ld l,a

	pop  ix
	ret