/*
 * RoboPlay for MSX
 * Copyright (C) 2020 by RoboSoft Inc.
 *
 * dro.h
 *
 * DRO: DOSBox Raw OPL player
 */

#ifndef __DRO_H
#define __DRO_H

#include <stdint.h>

#define DRO1_HARDWARE_TYPE_OPL2       0
#define DRO1_HARDWARE_TYPE_OPL3       1
#define DRO1_HARDWARE_TYPE_DUAL_OPL2  2

#define DRO2_HARDWARE_TYPE_OPL2       0
#define DRO2_HARDWARE_TYPE_DUAL_OPL2  1
#define DRO2_HARDWARE_TYPE_OPL3       2

typedef struct 
{
    char signature[8];
    uint16_t version_major;
    uint16_t version_minor;
} DRO_HEADER;

typedef struct
{
    uint32_t length_ms;
    uint32_t length_bytes;
    uint8_t  hardware_type;
    uint8_t  hardware_extra[3];
} DRO1_HEADER;

typedef struct
{
    uint32_t length_pairs;
    uint32_t length_ms;
    uint8_t hardware_type;
    uint8_t format;
    uint8_t compression;
    uint8_t short_delay_code;
    uint8_t long_delay_code;
    uint8_t code_map_length;   
} DRO2_HEADER;

typedef enum
{
    DRO_TYPE_0_1,
    DRO_TYPE_2_0
} DRO_TYPE;

uint8_t get_next_data_byte();

void handle_dro1_update();
void handle_dro2_update();

#endif /* __DRO_H */
