/*
 * RoboPlay for MSX
 * Copyright (C) 2020 by RoboSoft Inc.
 *
 * file.c
 */

#include <stdio.h>
#include <stdbool.h>
#include <stdint.h>
#include <string.h>
#include <fusion-c/header/msx_fusion.h>
#include <fusion-c/header/vars_msxDos.h>

#include "dos2.h"

#include "file.h"
#include "player.h"

#define MAX_PLAYER_SIZE 0x4000
#define PLAYER_SIGNATURE "ROBOPLAY"

#define SONG_NAME_BUFFER     0xD000
#define PLAYER_NAME_BUFFER   SONG_NAME_BUFFER + MAX_FILE_NAME_LENGTH
#define M3U_NAME_BUFFER      PLAYER_NAME_BUFFER + MAX_FILE_NAME_LENGTH
#define WORK_BUFFER          M3U_NAME_BUFFER + MAX_FILE_NAME_LENGTH

char *g_current_song_name = SONG_NAME_BUFFER;
char *g_current_player_name = PLAYER_NAME_BUFFER;
char *g_m3u_name = M3U_NAME_BUFFER;
char *work_buffer = WORK_BUFFER;

static int8_t  g_file_handle = -1;
static uint8_t counter;

void get_program_path(char *path)
{
    char *environment_name = "PROGRAM";
    REGS *regs;

    regs = _REGs();
    regs->hl = (unsigned int)environment_name;
    regs->de = (unsigned int)path;
    regs->bc = (unsigned int)0xff6b;
    IntDos();

    uint8_t found = strlen(path) - 1;
    while(path[found] != '\\' && path[found] != ':' && found > 0) found--;
    if(found) 
        path[found + 1] = '\0';
    else
        path[0] = '\0';
}

void find_first_file(char *name)
{
    strcpy(g_current_song_name, name);

    uint8_t found = strlen(g_current_song_name) - 1;
    while(g_current_song_name[found] != '\\' && g_current_song_name[found] != ':' && found > 0) found--;
    if(found) 
        g_current_song_name[found + 1] = '\0';
    else
        g_current_song_name[0] = '\0';

    if(!dos2_find_first_entry(name))
        strcat(g_current_song_name, &dos2_file_info_block[1]);
}

bool find_next_file()
{
    uint8_t found = strlen(g_current_song_name) - 1;
    while(g_current_song_name[found] != '\\' && g_current_song_name[found] != ':' && found > 0) found--;
    if(found) 
        g_current_song_name[found + 1] = '\0';
    else
        g_current_song_name[0] = '\0';

    bool no_file_found = dos2_find_next_entry();
    if(!no_file_found)
        strcat(g_current_song_name, &dos2_file_info_block[1]);

    return !no_file_found;
}

void load_player(char *const name)
{
    printf("\nLoading player: %s", name);
 
    int8_t player_file_handle = dos2_open(name, O_RDONLY);
    if (player_file_handle == -1)
        dos2_exit(__NOFIL);

    dos2_read(player_file_handle, g_roboplay_interface, MAX_PLAYER_SIZE);
    dos2_close(player_file_handle);

    if (strncmp(g_roboplay_interface->signature, PLAYER_SIGNATURE, 8))
    {
        printf(" ...Error\n\r");
        printf("\n\rNot a RoboPlay player file\n\r");
        dos2_exit(__INTER);
    }

    printf(" ...Done\n\r");
}

void file_open(char *const name, const bool player_file)
{
    if(player_file)
    {
        get_program_path(work_buffer);
        strcat(work_buffer, name);
    }
    else
    {
        strcpy(work_buffer, name);
    }

    if(g_file_handle == -1)
        printf("Loading file: %s ", work_buffer);
    else
        dos2_close(g_file_handle);

    g_file_handle = dos2_open(work_buffer, O_RDONLY);

    if (g_file_handle == -1)
        dos2_exit(__NOFIL);

    counter = 0;
}

void file_close()
{
    dos2_close(g_file_handle);
    g_file_handle = -1;

    for(uint8_t i = 0; i < counter; i++)
        printf("\b \b");
    printf("...Done\n\r");
}

uint16_t file_read(void *const destination, const uint16_t size)
{
    if(counter < 3)
        printf(".");
    else
        printf("\b\b\b   \b\b\b");
    counter = (counter < 3) ? counter + 1 : 0;

    int16_t bytes_read = dos2_read(g_file_handle, destination, size);
    return (bytes_read == -1) ? 0 : bytes_read;
}

bool file_exists(char *const name)
{
    int8_t file_handle = dos2_open(name, O_RDONLY);
    if (file_handle != -1) dos2_close(file_handle);

    return (file_handle != -1);
}