/*
 * RoboPlay for MSX
 * Copyright (C) 2020 by RoboSoft Inc.
 *
 * m3u.c
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <fusion-c/header/msx_fusion.h>

#include "dos2.h"
#include "player.h"
#include "m3u.h"

static int8_t   g_m3u_file_handle;
static uint16_t g_m3u_file_size = 0;
static uint16_t g_m3u_previous_line = 0;


void m3u_open_file(char *const name)
{
    g_m3u_file_handle = dos2_open(name, O_RDONLY);
    if (g_m3u_file_handle == -1)
        dos2_exit(__NOFIL);

    g_m3u_file_size = 0;

    int16_t bytes_read = 0;
    do
    {
        bytes_read = dos2_read(g_m3u_file_handle, (void*)DATA_SEGMENT_BASE, DATA_SEGMENT_SIZE);
        g_m3u_file_size += (bytes_read != -1) ? (uint16_t)bytes_read : 0;
    } while(bytes_read != -1);

    dos2_lseek(g_m3u_file_handle, SEEK_SET, 0);
}

void m3u_close_file()
{
    dos2_close(g_m3u_file_handle);
    g_m3u_file_handle = -1;
}

bool m3u_get_next_song(char *song_name, uint16_t max_name_length)
{
    bool result = true;
    do
    {
        uint16_t i = 0;
        while(i < max_name_length)
        {
            if(dos2_read(g_m3u_file_handle, &song_name[i], 1) == -1) 
            {
                result = false;
                break;
            }
            if(song_name[i] == '\n') break;
            if(song_name[i] != '\r') i++;
        }
        song_name[i] = '\0';
    }  while(result && (strlen(song_name) && song_name[0] == '#'));

    if(!strlen(song_name)) result = false;

    return result;
}

void m3u_get_random_song(char* song_name, uint16_t max_name_length)
{
    do
    {
        uint16_t offset = rand() % g_m3u_file_size;
        dos2_lseek(g_m3u_file_handle, offset, SEEK_SET);

        uint8_t data;
        int8_t  bytes_read;
        do
        {
            bytes_read = dos2_read(g_m3u_file_handle, &data, 1);
        } while(bytes_read != -1 && data != '\n');
    }
    while(!m3u_get_next_song(song_name, max_name_length));
}