/*
 * RoboPlay for MSX
 * Copyright (C) 2020 by RoboSoft Inc.
 *
 * memory.c
 */

#include "fusion-c/header/msx_fusion.h"
#include <fusion-c/header/rammapper.h>
#include <fusion-c/header/vars_msxDos.h>
#include <fusion-c/header/vars_msxBios.h>

#include <stdio.h>

#include "memory.h"
#include "player.h"

#define MAX_NR_SEGMENTS 256

#define PAGE_0           0
#define PAGE_1           1   
#define PAGE_2           2
#define PAGE_3           3

typedef struct
{
    uint8_t allocated_segment_number;
    uint8_t slot_address_of_mapper;
} SEGMENT_INFO;

static uint16_t g_segments_found = MAX_NR_SEGMENTS;
static uint8_t  g_last_used_segment = 0;
static uint8_t  g_current_slot = 0;

static SEGMENT_INFO g_segment_list[MAX_NR_SEGMENTS];

uint16_t pre_allocate_ram_segments()
{
    InitRamMapperInfo(4);
    
    MAPPERINFOBLOCK* pMapperInfoBlock = _GetRamMapperBaseTable();
    SEGMENTSTATUS* pSegmentStatus = 0;

    g_last_used_segment = START_SEGMENT_INDEX;

    g_segment_list[START_SEGMENT_INDEX].allocated_segment_number = Get_PN(PAGE_2);
    g_segment_list[START_SEGMENT_INDEX].slot_address_of_mapper = pMapperInfoBlock->slot;

    for (uint16_t i = 1; i < MAX_NR_SEGMENTS; i++)
    {
        pSegmentStatus = AllocateSegment(0, 0x20);

        if (pSegmentStatus->carryFlag)
        {
            g_segments_found = i;
            break;
        }

        g_segment_list[i].allocated_segment_number = pSegmentStatus->allocatedSegmentNumber;
        g_segment_list[i].slot_address_of_mapper = pSegmentStatus->slotAddressOfMapper;
    }

    return g_segments_found;
}

void reset_used_ram_segments()
{
    g_last_used_segment = START_SEGMENT_INDEX;
    set_active_ram_segment(g_last_used_segment);
}

uint8_t get_free_ram_segment()
{
    g_last_used_segment++;
    if (g_last_used_segment >= g_segments_found)
        Exit(_NORAM);

    return g_last_used_segment;
}

void set_active_ram_segment(uint8_t segment_number)
{
    Put_PN(PAGE_2, g_segment_list[segment_number].allocated_segment_number);

    if (g_current_slot != g_segment_list[segment_number].slot_address_of_mapper)
    {
        g_current_slot = g_segment_list[segment_number].slot_address_of_mapper;

        __asm
        ld a, (_g_current_slot)
        ld b, a
        ld hl, #DATA_SEGMENT_BASE
        call ENASLT
        __endasm;
    }
}