/*
 * RoboPlay for MSX
 * Copyright (C) 2020 by RoboSoft Inc.
 *
 * opl4.h
 */

#ifndef __OPL4_H
#define __OPL4_H

#include <stdbool.h>
#include <stdint.h>

#define OPL4_TIMER1_COUNT  0x02
#define OPL4_TIMER2_COUNT  0x03
#define OPL4_TIMER_CONTROL 0x04

bool opl4_detect();
void opl4_reset();

uint8_t opl4_sample_ram_banks();

void opl4_write_fm_register_array_1(const uint8_t reg, const uint8_t value);
void opl4_write_fm_register_array_2(const uint8_t reg, const uint8_t value);

void opl4_write_wave_register(const uint8_t reg, const uint8_t value);
void opl4_write_wave_data(uint8_t *const data, const uint16_t size);

uint8_t opl4_read_status_register();
uint8_t opl4_read_fm_register_array_1(const uint8_t reg);
uint8_t opl4_read_fm_register_array_2(const uint8_t reg);
uint8_t opl4_read_wave_register(const uint8_t reg);

void opl4_wait_for_ld();

#endif /* __OPL4_H */