/*
 * RoboPlay for MSX
 * Copyright (C) 2020 by RoboSoft Inc.
 *
 * opm.c
 */

#include <stdio.h>
#include <string.h>

#include <fusion-c/header/vars_msxSystem.h>
#include "player.h"
#include "opm.h"

static const char* g_opm_id_txt = "MCHFM0";

static bool    g_opm_detected;
static uint8_t g_opm_slot;

static uint8_t g_data;

void opm_find_slot()
{
    g_opm_detected = false;
    g_opm_slot = 0xFF;

    __asm
    ld d,#0xFF
    ld hl,#0xFCC1

 main_loop:
    inc d
    ld  a,#4
    cp  d
    jr  z,done

    ld  a,(hl)
    inc hl
    and #0x80
    jr  z,main_test
    call sub_test
    jr  c,main_loop
    ld  a,c
    ld  (_g_opm_slot),a
    ld  a,#01
    ld  (_g_opm_detected),a
    jr  done

main_test:
    ld  a,d
    call test_slot
    jr  c,main_loop
    ld  a,d
    ld  (_g_opm_slot),a
    ld  a,#01
    ld  (_g_opm_detected),a
    jr  done

sub_test:
    ld  e,#0xFC
sub_loop:
    ld  a,#4
    add a,e
    cp  #16
    scf
    ret z
    ld  e,a
    or  d
    or  #0x80
    ld  c,a
    call test_slot
    jr  c,sub_loop
    ld  a,c
    ret

test_slot:
    push bc
    push de
    push hl

    ld  b,#06
    ld  hl,#OPM_ID_ADDRESS - 1
    ld  de,(_g_opm_id_txt)
    dec de
search_id:
    push af

    inc hl
    inc de

    push de
    push bc
    call RDSLT
    pop  bc
    pop  de

    ex  de,hl
    cp  (hl)
    ex  de,hl
    jr  nz,no_opm

    pop af
    djnz search_id
    xor a
    jr  exit

no_opm:
    pop af
    scf

exit:
    pop hl
    pop de
    pop bc
    ret

done:
    __endasm;
}

bool opm_detected()
{
    return g_opm_detected;
}

uint8_t opm_get_slot()
{
    return g_opm_slot;
}

void opm_reset()
{
    opm_write_register(0x1B, 0);
    opm_write_register(0x18, 0);

    uint8_t i = 0x1F;
    do
    {
        opm_write_register(++i, 0);
    } while(i != 0xFF);
}

void opm_write_register(const uint8_t reg, const uint8_t value)
{
    reg;
    value;

    __asm
    ld  hl,#2
    add hl,sp
    ld  e,(hl)

    ld  a,(_g_opm_slot)
    ld  hl,#OPM_ADDRESS_REGISTER
    call WRTSLT

    ld  hl,#3
    add hl,sp
    ld  e,(hl)

    ld  a,(_g_opm_slot)
    ld  hl,#OPM_DATA_REGISTER
    call WRTSLT
    __endasm;
}

uint8_t opm_read_status_register()
{
    __asm
    ld  a,(_g_opm_slot)
    ld  hl,#OPM_STATUS_REGISTER
    call RDSLT
    ld  (_g_data),a
    __endasm;

    return g_data;
}
