/*
 * RoboPlay for MSX
 * Copyright (C) 2020 by RoboSoft Inc.
 *
 * opm.h
 */

#ifndef __OPM_H
#define __OPM_H

#include <stdbool.h>
#include <stdint.h>

#define OPM_ID_ADDRESS 0x0080

#define RDSLT  0x0C
#define WRTSLT 0x14

#define OPM_STATUS_REGISTER  0x3FF0
#define OPM_ADDRESS_REGISTER 0x3FF0
#define OPM_DATA_REGISTER    0x3FF1

void opm_find_slot();

bool opm_detected();
uint8_t opm_get_slot();

void opm_reset();

void    opm_write_register(const uint8_t reg, const uint8_t value);
uint8_t opm_read_status_register();

#endif /* __OPM_H */