/*
 * RoboPlay for MSX
 * Copyright (C) 2020 by RoboSoft Inc.
 * 
 * psg.c
 */

#include "psg.h"

__sfr __at 0xA0 psg_register_port;
__sfr __at 0xA1 psg_value_port;
__sfr __at 0xA2 psg_read_port;

void psg_reset()
{
    psg_register_port = 0x07;
    psg_value_port    = 0xBF;

    psg_register_port = 0x08;
    psg_value_port    = 0x00;

    psg_register_port = 0x09;
    psg_value_port    = 0x00;

    psg_register_port = 0x0A;
    psg_value_port    = 0x00;
}

void psg_write(const uint8_t reg, const uint8_t value)
{
    psg_register_port = reg;
    psg_value_port    = value;
}

uint8_t psg_read(const uint8_t reg)
{
    psg_register_port = reg;
    return psg_read_port;
}