/*
 * RoboPlay for MSX
 * Copyright (C) 2020 by RoboSoft Inc.
 *
 * roboplay.h
 */

#ifndef __ROBOPLAY_H
#define __ROBOPLAY_H

typedef enum
{
    ROBOPLAY_PLAY_MODE_SINGLE_FILE,
    ROBOPLAY_PLAY_MODE_M3U,
    ROBOPLAY_PLAY_MODE_M3U_RANDOM
} roboplay_play_mode;

void show_info();

void check_arguments(char **argv, int argc);
void find_player_name();

void find_extension(char *name);

void init_opl4_device();
void init_scc_device();
void init_opm_device();

void init_player();

void set_refresh();

bool play_song();

void set_opl_mode(const roboplay_opl_mode mode);

void write_opl_fm_1(const uint8_t reg, const uint8_t value);
void write_opl_fm_2(const uint8_t reg, const uint8_t value);

void write_opm_fm(const uint8_t reg, const uint8_t value);

#endif /* __ROBOPLAY_H */

