/*
 * RoboPlay for MSX
 * Copyright (C) 2020 by RoboSoft Inc.
 *
 * scc.c
 */

#include <stdio.h>
#include <string.h>

#include <fusion-c/header/vars_msxSystem.h>
#include "player.h"
#include "scc.h"

#define SELECT_SCC_SLOT         \
    __asm                       \
    ld a,(RAMAD2)               \
    ld (_g_original_slot),a     \
    ld  a,(_g_scc_slot)         \
    ld  h,#SCC_PAGE             \
    call ENASLT                 \
    __endasm;

#define DESELECT_SCC_SLOT       \
    __asm                       \
    ld  a,(_g_original_slot)    \
    ld  h,#SCC_PAGE             \
    call ENASLT                 \
    __endasm;

static bool    g_scc_detected;
static uint8_t g_scc_slot;

static uint8_t g_original_slot;

static uint8_t g_waveform_buffer[SCC_WAVEFORM_SIZE];

void scc_find_slot()
{
    g_scc_detected = false;
    g_scc_slot = 0xFF;

    /* Based on SCC detection routine by NYYRIKKI */
    __asm
    ld a,(RAMAD2)
    ld (_g_original_slot),a

    ld d,#0xFF
    ld hl,#0xFCC1

 main_loop:
    inc d
    ld  a,#4
    cp  d
    jr  z,done

    ld  a,(hl)
    inc hl
    and #0x80
    jr  z,main_test
    call sub_test
    jr  c,main_loop
    ld  a,c
    ld  (_g_scc_slot),a
    ld  a,#01
    ld  (_g_scc_detected),a
    jr  done

main_test:
    ld  a,d
    call test_slot
    jr  c,main_loop
    ld  a,d
    ld  (_g_scc_slot),a
    ld  a,#01
    ld  (_g_scc_detected),a
    jr  done

sub_test:
    ld  e,#0xFC
sub_loop:
    ld  a,#4
    add a,e
    cp  #16
    scf
    ret z
    ld  e,a
    or  d
    or  #0x80
    ld  c,a
    call test_slot
    jr  c,sub_loop
    ld  a,c
    ret

test_slot:
    push bc
    push de
    push hl

    ld  h,#SCC_PAGE
    call ENASLT

    ld  a,(#SCC_BANK_SELECT)
    ld  d,a
    ld  a,#0x3F
    ld  (#SCC_BANK_SELECT),a
    ld  hl,#0x9800
    ld  e,(hl)
    xor a
    ld  (hl),a
    ld  a,(hl)
    or  a
    jr  nz,no_scc
    dec a
    ld  (hl),a
    ld  a,(hl)
    inc a
    jr  nz,no_scc
    ld  a,(#SCC_BANK_SELECT)
    cp  #0x3F
    jr  z,no_scc
    xor a
    jr  exit
no_scc:
    ld  (hl),e
    ld  a,d
    ld  (#SCC_BANK_SELECT),a
    scf
exit:
    pop hl
    pop de
    pop bc
    ret

done:
    __endasm;

    DESELECT_SCC_SLOT
}

bool scc_detected()
{
    return g_scc_detected;
}

uint8_t scc_get_slot()
{
    return g_scc_slot;
}

void scc_reset()
{
    SELECT_SCC_SLOT

    for(uint8_t i = 0; i < SCC_NR_OF_CHANNELS - 1; i++)
    {
        for(uint8_t j = 0; j < SCC_WAVEFORM_SIZE; j++)
            g_scc_registers.waveform[i][j] = 0;
    }

    for(uint8_t i = 0; i < SCC_NR_OF_CHANNELS; i++)
    {
        *g_scc_registers.frequency[i] = 0;
        *g_scc_registers.volume[i] = 0;
    }

    *g_scc_registers.voice_on = 0x1F;

    DESELECT_SCC_SLOT
}

void scc_set_waveform(uint8_t channel, uint8_t *waveform)
{
    memcpy(g_waveform_buffer, waveform, SCC_WAVEFORM_SIZE);

    SELECT_SCC_SLOT

    memcpy(g_scc_registers.waveform[channel], g_waveform_buffer, SCC_WAVEFORM_SIZE);

    DESELECT_SCC_SLOT
}

void scc_set_frequency(uint8_t channel, uint16_t frequency)
{
    SELECT_SCC_SLOT

    *g_scc_registers.frequency[channel] = frequency;

    DESELECT_SCC_SLOT
}

void scc_set_volume(uint8_t channel, uint8_t volume)
{
    SELECT_SCC_SLOT

    *g_scc_registers.volume[channel] = volume;

    DESELECT_SCC_SLOT
}

void scc_write_register(uint8_t reg, uint8_t value)
{
    SELECT_SCC_SLOT

    uint8_t* address = (uint8_t *)(SCC_REGISTER_BASE + reg);
    *address = value;

    DESELECT_SCC_SLOT
}