/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass;

import java.io.File;
import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.Line;
import nl.grauw.glass.Scope;
import nl.grauw.glass.expressions.CharacterLiteral;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.ExpressionBuilder;
import nl.grauw.glass.expressions.Identifier;
import nl.grauw.glass.expressions.IntegerLiteral;
import nl.grauw.glass.expressions.StringLiteral;

public class LineParser {
    private Scope scope;
    private String label;
    private String mnemonic;
    private Expression arguments;
    private String comment;
    private State state;
    private StringBuilder accumulator = new StringBuilder();
    private ExpressionBuilder expressionBuilder = new ExpressionBuilder();
    private LabelStartState labelStartState = new LabelStartState();
    private LabelReadState labelReadState = new LabelReadState();
    private StatementStartState statementStartState = new StatementStartState();
    private StatementReadState statementReadState = new StatementReadState();
    private ArgumentStartState argumentStartState = new ArgumentStartState();
    private ArgumentValueState argumentValueState = new ArgumentValueState();
    private ArgumentIdentifierState argumentIdentifierState = new ArgumentIdentifierState();
    private ArgumentStringState argumentStringState = new ArgumentStringState();
    private ArgumentStringEscapeState argumentStringEscapeState = new ArgumentStringEscapeState();
    private ArgumentCharacterState argumentCharacterState = new ArgumentCharacterState();
    private ArgumentCharacterEscapeState argumentCharacterEscapeState = new ArgumentCharacterEscapeState();
    private ArgumentCharacterEndState argumentCharacterEndState = new ArgumentCharacterEndState();
    private ArgumentNumberState argumentNumberState = new ArgumentNumberState();
    private ArgumentOperatorState argumentOperatorState = new ArgumentOperatorState();
    private ArgumentLessThanState argumentLessThanState = new ArgumentLessThanState();
    private ArgumentGreaterThanState argumentGreaterThanState = new ArgumentGreaterThanState();
    private ArgumentNotEqualsState argumentNotEqualsState = new ArgumentNotEqualsState();
    private ArgumentAndState argumentAndState = new ArgumentAndState();
    private ArgumentOrState argumentOrState = new ArgumentOrState();
    private CommentReadState commentReadState = new CommentReadState();
    private EndState endState = new EndState();

    public Line parse(String text, Scope scope, File sourceFile, int lineNumber) {
        this.scope = scope;
        this.label = null;
        this.mnemonic = null;
        this.arguments = null;
        this.comment = null;
        this.state = this.labelStartState;
        int column = 0;
        try {
            int length = text.length();
            for (int i = 0; i < length; ++i) {
                column = i;
                this.state = this.state.parse(text.charAt(i));
            }
            column = text.length();
            this.state = this.state.parse('\u0000');
            if (this.accumulator.length() > 0) {
                throw new AssemblyException("Accumulator not consumed. Value: " + this.accumulator.toString());
            }
            if (this.state != this.endState) {
                throw new AssemblyException("Invalid line end state: " + this.state.getClass().getSimpleName());
            }
        }
        catch (AssemblyException e) {
            e.setContext(sourceFile, lineNumber, text, column);
            throw e;
        }
        return new Line(scope, this.label, this.mnemonic, this.arguments, this.comment, sourceFile, lineNumber);
    }

    public static class SyntaxError
    extends AssemblyException {
        private static final long serialVersionUID = 1L;

        public SyntaxError() {
            this((Throwable)null);
        }

        public SyntaxError(Throwable cause) {
            super("Syntax error.", cause);
        }
    }

    private class EndState
    extends State {
        private EndState() {
        }

        @Override
        public State parse(char character) {
            throw new AssemblyException("End state reached but not all characters consumed.");
        }
    }

    private class CommentReadState
    extends State {
        private CommentReadState() {
        }

        @Override
        public State parse(char character) {
            if (character == '\u0000') {
                LineParser.this.comment = LineParser.this.accumulator.toString();
                LineParser.this.accumulator.setLength(0);
                return LineParser.this.endState;
            }
            LineParser.this.accumulator.append(character);
            return LineParser.this.commentReadState;
        }
    }

    private class ArgumentOrState
    extends State {
        private ArgumentOrState() {
        }

        @Override
        public State parse(char character) {
            if (character == '|') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.LOGICAL_OR);
                return LineParser.this.argumentValueState;
            }
            LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.OR);
            return LineParser.this.argumentValueState.parse(character);
        }
    }

    private class ArgumentAndState
    extends State {
        private ArgumentAndState() {
        }

        @Override
        public State parse(char character) {
            if (character == '&') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.LOGICAL_AND);
                return LineParser.this.argumentValueState;
            }
            LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.AND);
            return LineParser.this.argumentValueState.parse(character);
        }
    }

    private class ArgumentNotEqualsState
    extends State {
        private ArgumentNotEqualsState() {
        }

        @Override
        public State parse(char character) {
            if (character == '=') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.NOT_EQUALS);
                return LineParser.this.argumentValueState;
            }
            throw new SyntaxError();
        }
    }

    private class ArgumentGreaterThanState
    extends State {
        private ArgumentGreaterThanState() {
        }

        @Override
        public State parse(char character) {
            if (character == '>') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.SHIFT_RIGHT);
                return LineParser.this.argumentValueState;
            }
            if (character == '=') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.GREATER_OR_EQUALS);
                return LineParser.this.argumentValueState;
            }
            LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.GREATER_THAN);
            return LineParser.this.argumentValueState.parse(character);
        }
    }

    private class ArgumentLessThanState
    extends State {
        private ArgumentLessThanState() {
        }

        @Override
        public State parse(char character) {
            if (character == '<') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.SHIFT_LEFT);
                return LineParser.this.argumentValueState;
            }
            if (character == '=') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.LESS_OR_EQUALS);
                return LineParser.this.argumentValueState;
            }
            LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.LESS_THAN);
            return LineParser.this.argumentValueState.parse(character);
        }
    }

    private class ArgumentOperatorState
    extends State {
        private ArgumentOperatorState() {
        }

        @Override
        public State parse(char character) {
            if (character == ')') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.GROUP_CLOSE);
                return LineParser.this.argumentOperatorState;
            }
            if (character == '*') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.MULTIPLY);
                return LineParser.this.argumentValueState;
            }
            if (character == '/') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.DIVIDE);
                return LineParser.this.argumentValueState;
            }
            if (character == '%') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.MODULO);
                return LineParser.this.argumentValueState;
            }
            if (character == '+') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.ADD);
                return LineParser.this.argumentValueState;
            }
            if (character == '-') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.SUBTRACT);
                return LineParser.this.argumentValueState;
            }
            if (character == '<') {
                return LineParser.this.argumentLessThanState;
            }
            if (character == '>') {
                return LineParser.this.argumentGreaterThanState;
            }
            if (character == '=') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.EQUALS);
                return LineParser.this.argumentValueState;
            }
            if (character == '!') {
                return LineParser.this.argumentNotEqualsState;
            }
            if (character == '&') {
                return LineParser.this.argumentAndState;
            }
            if (character == '^') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.XOR);
                return LineParser.this.argumentValueState;
            }
            if (character == '|') {
                return LineParser.this.argumentOrState;
            }
            if (character == ',') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.SEQUENCE);
                return LineParser.this.argumentValueState;
            }
            if (this.isWhitespace(character)) {
                return LineParser.this.argumentOperatorState;
            }
            if (character == ';') {
                LineParser.this.arguments = LineParser.this.expressionBuilder.getExpression();
                return LineParser.this.commentReadState;
            }
            if (character == '\u0000') {
                LineParser.this.arguments = LineParser.this.expressionBuilder.getExpression();
                return LineParser.this.endState;
            }
            throw new SyntaxError();
        }
    }

    private class ArgumentNumberState
    extends State {
        private ArgumentNumberState() {
        }

        @Override
        public State parse(char character) {
            if (character >= '0' && character <= '9' || character >= 'A' && character <= 'F' || character >= 'a' && character <= 'f') {
                LineParser.this.accumulator.append(character);
                return LineParser.this.argumentNumberState;
            }
            String string = LineParser.this.accumulator.toString();
            if (character == 'H' || character == 'h') {
                int value = this.parseInt(string, 16);
                LineParser.this.expressionBuilder.addValueToken(new IntegerLiteral(value));
                LineParser.this.accumulator.setLength(0);
                return LineParser.this.argumentOperatorState;
            }
            if (character == 'O' || character == 'o') {
                int value = this.parseInt(string, 8);
                LineParser.this.expressionBuilder.addValueToken(new IntegerLiteral(value));
                LineParser.this.accumulator.setLength(0);
                return LineParser.this.argumentOperatorState;
            }
            if (string.endsWith("B") || string.endsWith("b")) {
                int value = this.parseInt(string.substring(0, string.length() - 1), 2);
                LineParser.this.expressionBuilder.addValueToken(new IntegerLiteral(value));
                LineParser.this.accumulator.setLength(0);
            } else {
                int value = this.parseInt(string, 10);
                LineParser.this.expressionBuilder.addValueToken(new IntegerLiteral(value));
                LineParser.this.accumulator.setLength(0);
            }
            return LineParser.this.argumentOperatorState.parse(character);
        }

        private int parseInt(String string, int radix) {
            long value = Long.parseLong(string, radix);
            if (value > 0xFFFFFFFFL) {
                throw new SyntaxError();
            }
            return (int)value;
        }
    }

    private class ArgumentCharacterEndState
    extends State {
        private ArgumentCharacterEndState() {
        }

        @Override
        public State parse(char character) {
            if (character == '\'') {
                LineParser.this.expressionBuilder.addValueToken(new CharacterLiteral(LineParser.this.accumulator.charAt(0)));
                LineParser.this.accumulator.setLength(0);
                return LineParser.this.argumentOperatorState;
            }
            throw new SyntaxError();
        }
    }

    private class ArgumentCharacterEscapeState
    extends State {
        private ArgumentCharacterEscapeState() {
        }

        @Override
        public State parse(char character) {
            State state = LineParser.this.argumentStringEscapeState.parse(character);
            if (state == LineParser.this.argumentStringState) {
                return LineParser.this.argumentCharacterEndState;
            }
            throw new AssemblyException("Unexpected state.");
        }
    }

    private class ArgumentCharacterState
    extends State {
        private ArgumentCharacterState() {
        }

        @Override
        public State parse(char character) {
            if (character == '\\') {
                return LineParser.this.argumentCharacterEscapeState;
            }
            if (character == '\'' || character == '\u0000') {
                throw new SyntaxError();
            }
            LineParser.this.accumulator.append(character);
            return LineParser.this.argumentCharacterEndState;
        }
    }

    private class ArgumentStringEscapeState
    extends State {
        private ArgumentStringEscapeState() {
        }

        @Override
        public State parse(char character) {
            if (character == '0') {
                LineParser.this.accumulator.append('\u0000');
                return LineParser.this.argumentStringState;
            }
            if (character == 'a') {
                LineParser.this.accumulator.append('\u0007');
                return LineParser.this.argumentStringState;
            }
            if (character == 't') {
                LineParser.this.accumulator.append('\t');
                return LineParser.this.argumentStringState;
            }
            if (character == 'n') {
                LineParser.this.accumulator.append('\n');
                return LineParser.this.argumentStringState;
            }
            if (character == 'f') {
                LineParser.this.accumulator.append('\f');
                return LineParser.this.argumentStringState;
            }
            if (character == 'r') {
                LineParser.this.accumulator.append('\r');
                return LineParser.this.argumentStringState;
            }
            if (character == 'e') {
                LineParser.this.accumulator.append('\u001b');
                return LineParser.this.argumentStringState;
            }
            if (character == '\"') {
                LineParser.this.accumulator.append('\"');
                return LineParser.this.argumentStringState;
            }
            if (character == '\'') {
                LineParser.this.accumulator.append('\'');
                return LineParser.this.argumentStringState;
            }
            if (character == '\\') {
                LineParser.this.accumulator.append('\\');
                return LineParser.this.argumentStringState;
            }
            if (character == '\u0000') {
                throw new SyntaxError();
            }
            throw new SyntaxError();
        }
    }

    private class ArgumentStringState
    extends State {
        private ArgumentStringState() {
        }

        @Override
        public State parse(char character) {
            if (character == '\"') {
                LineParser.this.expressionBuilder.addValueToken(new StringLiteral(LineParser.this.accumulator.toString()));
                LineParser.this.accumulator.setLength(0);
                return LineParser.this.argumentOperatorState;
            }
            if (character == '\\') {
                return LineParser.this.argumentStringEscapeState;
            }
            if (character == '\u0000') {
                throw new SyntaxError();
            }
            LineParser.this.accumulator.append(character);
            return LineParser.this.argumentStringState;
        }
    }

    private class ArgumentIdentifierState
    extends State {
        private ArgumentIdentifierState() {
        }

        @Override
        public State parse(char character) {
            if (this.isIdentifier(character)) {
                LineParser.this.accumulator.append(character);
                return LineParser.this.argumentIdentifierState;
            }
            LineParser.this.expressionBuilder.addValueToken(new Identifier(LineParser.this.accumulator.toString(), LineParser.this.scope));
            LineParser.this.accumulator.setLength(0);
            return LineParser.this.argumentOperatorState.parse(character);
        }
    }

    private class ArgumentValueState
    extends State {
        private ArgumentValueState() {
        }

        @Override
        public State parse(char character) {
            if (this.isIdentifierStart(character)) {
                LineParser.this.accumulator.append(character);
                return LineParser.this.argumentIdentifierState;
            }
            if (character == '$') {
                LineParser.this.expressionBuilder.addValueToken(new Identifier("$", LineParser.this.scope));
                return LineParser.this.argumentOperatorState;
            }
            if (character >= '0' && character <= '9') {
                LineParser.this.accumulator.append(character);
                return LineParser.this.argumentNumberState;
            }
            if (character == '\"') {
                return LineParser.this.argumentStringState;
            }
            if (character == '\'') {
                return LineParser.this.argumentCharacterState;
            }
            if (character == '+') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.POSITIVE);
                return LineParser.this.argumentValueState;
            }
            if (character == '-') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.NEGATIVE);
                return LineParser.this.argumentValueState;
            }
            if (character == '~') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.COMPLEMENT);
                return LineParser.this.argumentValueState;
            }
            if (character == '!') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.NOT);
                return LineParser.this.argumentValueState;
            }
            if (character == '(') {
                LineParser.this.expressionBuilder.addOperatorToken(ExpressionBuilder.Operator.GROUP_OPEN);
                return LineParser.this.argumentValueState;
            }
            if (this.isWhitespace(character)) {
                return LineParser.this.argumentValueState;
            }
            throw new SyntaxError();
        }
    }

    private class ArgumentStartState
    extends State {
        private ArgumentStartState() {
        }

        @Override
        public State parse(char character) {
            if (character == ';') {
                return LineParser.this.commentReadState;
            }
            if (character == '\u0000') {
                return LineParser.this.endState;
            }
            if (this.isWhitespace(character)) {
                return LineParser.this.argumentStartState;
            }
            return LineParser.this.argumentValueState.parse(character);
        }
    }

    private class StatementReadState
    extends State {
        private StatementReadState() {
        }

        @Override
        public State parse(char character) {
            if (this.isIdentifier(character)) {
                LineParser.this.accumulator.append(character);
                return LineParser.this.statementReadState;
            }
            LineParser.this.mnemonic = LineParser.this.accumulator.toString();
            LineParser.this.accumulator.setLength(0);
            if (this.isWhitespace(character)) {
                return LineParser.this.argumentStartState;
            }
            if (character == ';') {
                return LineParser.this.commentReadState;
            }
            if (character == '\u0000') {
                return LineParser.this.endState;
            }
            throw new SyntaxError();
        }
    }

    private class StatementStartState
    extends State {
        private StatementStartState() {
        }

        @Override
        public State parse(char character) {
            if (this.isIdentifierStart(character)) {
                LineParser.this.accumulator.append(character);
                return LineParser.this.statementReadState;
            }
            if (this.isWhitespace(character)) {
                return LineParser.this.statementStartState;
            }
            if (character == ';') {
                return LineParser.this.commentReadState;
            }
            if (character == '\u0000') {
                return LineParser.this.endState;
            }
            throw new SyntaxError();
        }
    }

    private class LabelReadState
    extends State {
        private LabelReadState() {
        }

        @Override
        public State parse(char character) {
            if (this.isIdentifier(character)) {
                LineParser.this.accumulator.append(character);
                return LineParser.this.labelReadState;
            }
            LineParser.this.label = LineParser.this.accumulator.toString();
            LineParser.this.accumulator.setLength(0);
            if (character == ':' || this.isWhitespace(character)) {
                return LineParser.this.statementStartState;
            }
            if (character == ';') {
                return LineParser.this.commentReadState;
            }
            if (character == '\u0000') {
                return LineParser.this.endState;
            }
            throw new SyntaxError();
        }
    }

    private class LabelStartState
    extends State {
        private LabelStartState() {
        }

        @Override
        public State parse(char character) {
            if (this.isIdentifierStart(character)) {
                LineParser.this.accumulator.append(character);
                return LineParser.this.labelReadState;
            }
            if (this.isWhitespace(character)) {
                return LineParser.this.statementStartState;
            }
            if (character == ';') {
                return LineParser.this.commentReadState;
            }
            if (character == '\u0000') {
                return LineParser.this.endState;
            }
            throw new SyntaxError();
        }
    }

    private abstract class State {
        private State() {
        }

        public abstract State parse(char var1);

        public boolean isWhitespace(char character) {
            return character == ' ' || character == '\t';
        }

        public boolean isIdentifier(char character) {
            return this.isIdentifierStart(character) || character >= '0' && character <= '9' || character == '$' || character == '\'';
        }

        public boolean isIdentifierStart(char character) {
            return character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || character == '_' || character == '.' || character == '?' || character == '@';
        }
    }
}

