/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import java.util.ArrayDeque;
import java.util.Deque;
import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.expressions.Add;
import nl.grauw.glass.expressions.And;
import nl.grauw.glass.expressions.Complement;
import nl.grauw.glass.expressions.Divide;
import nl.grauw.glass.expressions.Equals;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.GreaterOrEquals;
import nl.grauw.glass.expressions.GreaterThan;
import nl.grauw.glass.expressions.Group;
import nl.grauw.glass.expressions.LessOrEquals;
import nl.grauw.glass.expressions.LessThan;
import nl.grauw.glass.expressions.LogicalAnd;
import nl.grauw.glass.expressions.LogicalOr;
import nl.grauw.glass.expressions.Modulo;
import nl.grauw.glass.expressions.Multiply;
import nl.grauw.glass.expressions.Negative;
import nl.grauw.glass.expressions.Not;
import nl.grauw.glass.expressions.NotEquals;
import nl.grauw.glass.expressions.Or;
import nl.grauw.glass.expressions.Positive;
import nl.grauw.glass.expressions.Sequence;
import nl.grauw.glass.expressions.ShiftLeft;
import nl.grauw.glass.expressions.ShiftRight;
import nl.grauw.glass.expressions.Subtract;
import nl.grauw.glass.expressions.Xor;

public class ExpressionBuilder {
    private Deque<Expression> operands = new ArrayDeque<Expression>();
    private Deque<Operator> operators = new ArrayDeque<Operator>();

    public ExpressionBuilder() {
        this.operators.push(Operator.SENTINEL);
    }

    public void addValueToken(Expression value) {
        this.operands.push(value);
    }

    public void addOperatorToken(Operator operator) {
        while (!this.operators.peek().yieldsTo(operator) && this.operators.peek() != Operator.SENTINEL) {
            this.operators.pop().evaluate(this.operands);
        }
        if (operator == Operator.GROUP_OPEN) {
            this.operators.push(operator);
            this.operators.push(Operator.SENTINEL);
        } else if (operator == Operator.GROUP_CLOSE) {
            if (this.operators.pop() != Operator.SENTINEL) {
                throw new AssemblyException("Sentinel expected.");
            }
            if (this.operators.peek() != Operator.GROUP_OPEN) {
                throw new ExpressionError("Group open expected.");
            }
        } else {
            this.operators.push(operator);
        }
    }

    public Expression getExpression() {
        if (this.operands.isEmpty() || this.operators.isEmpty()) {
            throw new AssemblyException("Operands / operators is empty: " + this);
        }
        while (this.operators.peek() != Operator.SENTINEL) {
            this.operators.pop().evaluate(this.operands);
        }
        if (this.operators.size() > 1 && this.operators.peek() == Operator.SENTINEL) {
            throw new ExpressionError("Group close expected.");
        }
        if (this.operands.size() > 1 || this.operators.size() != 1) {
            throw new AssemblyException("Not all operands / operators were processed: " + this);
        }
        return this.operands.pop();
    }

    public String toString() {
        return "" + this.operands + " / " + this.operators;
    }

    public static class ExpressionError
    extends AssemblyException {
        private static final long serialVersionUID = 1L;

        public ExpressionError(String message) {
            super("Expression error: " + message);
        }
    }

    private static enum Precedence {
        GROUPING,
        UNARY,
        MULTIPLICATION,
        ADDITION,
        SHIFT,
        COMPARISON,
        EQUALITY,
        AND,
        XOR,
        OR,
        LOGICAL_AND,
        LOGICAL_OR,
        ASSIGNMENT,
        SEQUENCE,
        NONE;

    }

    public static enum Operator {
        POSITIVE(Precedence.UNARY, true),
        NEGATIVE(Precedence.UNARY, true),
        COMPLEMENT(Precedence.UNARY, true),
        NOT(Precedence.UNARY, true),
        MULTIPLY(Precedence.MULTIPLICATION, true),
        DIVIDE(Precedence.MULTIPLICATION, true),
        MODULO(Precedence.MULTIPLICATION, true),
        ADD(Precedence.ADDITION, true),
        SUBTRACT(Precedence.ADDITION, true),
        SHIFT_LEFT(Precedence.SHIFT, true),
        SHIFT_RIGHT(Precedence.SHIFT, true),
        LESS_THAN(Precedence.COMPARISON, true),
        LESS_OR_EQUALS(Precedence.COMPARISON, true),
        GREATER_THAN(Precedence.COMPARISON, true),
        GREATER_OR_EQUALS(Precedence.COMPARISON, true),
        EQUALS(Precedence.EQUALITY, true),
        NOT_EQUALS(Precedence.EQUALITY, true),
        AND(Precedence.AND, true),
        XOR(Precedence.XOR, true),
        OR(Precedence.OR, true),
        LOGICAL_AND(Precedence.LOGICAL_AND, true),
        LOGICAL_OR(Precedence.LOGICAL_OR, true),
        GROUP_OPEN(Precedence.GROUPING, true),
        GROUP_CLOSE(Precedence.NONE, true),
        SEQUENCE(Precedence.SEQUENCE, false),
        SENTINEL(Precedence.NONE, true);

        private Precedence precedence;
        private boolean leftAssociative;

        private Operator(Precedence precedence, boolean leftAssociative) {
            this.precedence = precedence;
            this.leftAssociative = leftAssociative;
        }

        public boolean yieldsTo(Operator other) {
            if (this.leftAssociative) {
                return this.precedence.ordinal() > other.precedence.ordinal();
            }
            return this.precedence.ordinal() >= other.precedence.ordinal();
        }

        public void evaluate(Deque<Expression> operands) {
            Expression operandRight = operands.pop();
            Expression result = this.precedence == Precedence.UNARY || this.precedence == Precedence.GROUPING ? this.evaluate(operandRight) : this.evaluate(operands.pop(), operandRight);
            operands.push(result);
        }

        private Expression evaluate(Expression operand) {
            switch (this) {
                case POSITIVE: {
                    return new Positive(operand);
                }
                case NEGATIVE: {
                    return new Negative(operand);
                }
                case COMPLEMENT: {
                    return new Complement(operand);
                }
                case NOT: {
                    return new Not(operand);
                }
                case GROUP_OPEN: {
                    return new Group(operand);
                }
            }
            throw new AssemblyException("Not an unary or group operator: " + (Object)((Object)this));
        }

        private Expression evaluate(Expression operand1, Expression operand2) {
            switch (this) {
                case MULTIPLY: {
                    return new Multiply(operand1, operand2);
                }
                case DIVIDE: {
                    return new Divide(operand1, operand2);
                }
                case MODULO: {
                    return new Modulo(operand1, operand2);
                }
                case ADD: {
                    return new Add(operand1, operand2);
                }
                case SUBTRACT: {
                    return new Subtract(operand1, operand2);
                }
                case SHIFT_LEFT: {
                    return new ShiftLeft(operand1, operand2);
                }
                case SHIFT_RIGHT: {
                    return new ShiftRight(operand1, operand2);
                }
                case LESS_THAN: {
                    return new LessThan(operand1, operand2);
                }
                case LESS_OR_EQUALS: {
                    return new LessOrEquals(operand1, operand2);
                }
                case GREATER_THAN: {
                    return new GreaterThan(operand1, operand2);
                }
                case GREATER_OR_EQUALS: {
                    return new GreaterOrEquals(operand1, operand2);
                }
                case EQUALS: {
                    return new Equals(operand1, operand2);
                }
                case NOT_EQUALS: {
                    return new NotEquals(operand1, operand2);
                }
                case AND: {
                    return new And(operand1, operand2);
                }
                case XOR: {
                    return new Xor(operand1, operand2);
                }
                case OR: {
                    return new Or(operand1, operand2);
                }
                case LOGICAL_AND: {
                    return new LogicalAnd(operand1, operand2);
                }
                case LOGICAL_OR: {
                    return new LogicalOr(operand1, operand2);
                }
                case SEQUENCE: {
                    return new Sequence(operand1, operand2);
                }
            }
            throw new ExpressionError("Not a binary operator: " + (Object)((Object)this));
        }
    }
}

