/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import nl.grauw.glass.Scope;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Register;
import nl.grauw.glass.expressions.Schema;
import nl.grauw.glass.instructions.ArgumentException;
import nl.grauw.glass.instructions.Instruction;
import nl.grauw.glass.instructions.InstructionObject;

public class Bit
extends Instruction {
    @Override
    public InstructionObject createObject(Expression arguments) {
        if (Bit_N_R.ARGUMENTS.check(arguments)) {
            return new Bit_N_R(arguments.getElement(0), arguments.getElement(1));
        }
        throw new ArgumentException();
    }

    public static class Bit_N_R
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_N, Schema.DIRECT_R_INDIRECT_HL_IX_IY);
        private Expression argument1;
        private Expression argument2;

        public Bit_N_R(Expression argument1, Expression argument2) {
            this.argument1 = argument1;
            this.argument2 = argument2;
        }

        @Override
        public int getSize(Scope context) {
            return this.indexifyIndirect(this.argument2.getRegister(), 2);
        }

        @Override
        public byte[] getBytes(Scope context) {
            int value = this.argument1.getInteger();
            if (value < 0 || value > 7) {
                throw new ArgumentException();
            }
            Register register = this.argument2.getRegister();
            return this.indexifyIndirect(register, (byte)-53, (byte)(0x40 | value << 3 | register.get8BitCode()));
        }
    }
}

