/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import nl.grauw.glass.Scope;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Schema;
import nl.grauw.glass.instructions.ArgumentException;
import nl.grauw.glass.instructions.Instruction;
import nl.grauw.glass.instructions.InstructionObject;

public class Djnz
extends Instruction {
    @Override
    public InstructionObject createObject(Expression arguments) {
        if (Djnz_N.ARGUMENTS.check(arguments)) {
            return new Djnz_N(arguments);
        }
        throw new ArgumentException();
    }

    public static class Djnz_N
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_N);
        private Expression argument;

        public Djnz_N(Expression arguments) {
            this.argument = arguments;
        }

        @Override
        public int getSize(Scope context) {
            return 2;
        }

        @Override
        public byte[] getBytes(Scope context) {
            int offset = this.argument.getAddress() - (context.getAddress() + 2);
            if (offset < -128 || offset > 127) {
                throw new ArgumentException("Jump offset out of range: " + offset);
            }
            return new byte[]{16, (byte)offset};
        }
    }
}

