/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import nl.grauw.glass.Scope;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Register;
import nl.grauw.glass.expressions.Schema;
import nl.grauw.glass.instructions.ArgumentException;
import nl.grauw.glass.instructions.Instruction;
import nl.grauw.glass.instructions.InstructionObject;

public class Inc
extends Instruction {
    @Override
    public InstructionObject createObject(Expression arguments) {
        if (Inc_R.ARGUMENTS.check(arguments)) {
            return new Inc_R(arguments.getElement(0));
        }
        if (Inc_RR.ARGUMENTS.check(arguments)) {
            return new Inc_RR(arguments.getElement(0));
        }
        throw new ArgumentException();
    }

    public static class Inc_RR
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_RR_INDEX);
        private Expression argument;

        public Inc_RR(Expression arguments) {
            this.argument = arguments;
        }

        @Override
        public int getSize(Scope context) {
            return this.indexifyDirect(this.argument.getRegister(), 1);
        }

        @Override
        public byte[] getBytes(Scope context) {
            Register register = this.argument.getRegister();
            return this.indexifyDirect(register, (byte)(3 | register.get16BitCode() << 4));
        }
    }

    public static class Inc_R
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_R_INDIRECT_HL_IX_IY);
        private Expression argument;

        public Inc_R(Expression arguments) {
            this.argument = arguments;
        }

        @Override
        public int getSize(Scope context) {
            return this.indexifyIndirect(this.argument.getRegister(), 1);
        }

        @Override
        public byte[] getBytes(Scope context) {
            Register register = this.argument.getRegister();
            return this.indexifyIndirect(register, (byte)(4 | register.get8BitCode() << 3));
        }
    }
}

