/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import java.util.List;
import nl.grauw.glass.Line;
import nl.grauw.glass.ParameterScope;
import nl.grauw.glass.Source;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Schema;
import nl.grauw.glass.instructions.ArgumentException;
import nl.grauw.glass.instructions.Empty;
import nl.grauw.glass.instructions.Instruction;
import nl.grauw.glass.instructions.InstructionObject;

public class Irp
extends Instruction {
    private final Source source;

    public Irp(Source source) {
        this.source = source;
    }

    @Override
    public List<Line> expand(Line line) {
        Expression arguments = line.getArguments();
        if (arguments == null || !Schema.IDENTIFIER.check(arguments.getElement())) {
            throw new ArgumentException();
        }
        List<Line> lines = super.expand(line);
        Expression parameter = arguments.getElement();
        int i = 0;
        while ((arguments = arguments.getNext()) != null) {
            ParameterScope parameterScope = new ParameterScope(line.getScope(), parameter, arguments.getElement());
            List<Line> lineCopies = this.source.getLineCopies(parameterScope);
            for (Line lineCopy : lineCopies) {
                lineCopy.register(parameterScope);
            }
            for (Line lineCopy : lineCopies) {
                lines.addAll(lineCopy.expand());
            }
            line.getScope().addSymbol(Integer.toString(i), parameterScope);
            ++i;
        }
        return lines;
    }

    @Override
    public InstructionObject createObject(Expression arguments) {
        return Empty.EmptyObject.INSTANCE;
    }
}

