/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import nl.grauw.glass.Scope;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Register;
import nl.grauw.glass.expressions.Schema;
import nl.grauw.glass.instructions.ArgumentException;
import nl.grauw.glass.instructions.Instruction;
import nl.grauw.glass.instructions.InstructionObject;

public class Xor
extends Instruction {
    @Override
    public InstructionObject createObject(Expression arguments) {
        if (Xor_R.ARGUMENTS.check(arguments)) {
            return new Xor_R(arguments);
        }
        if (Xor_N.ARGUMENTS.check(arguments)) {
            return new Xor_N(arguments);
        }
        throw new ArgumentException();
    }

    public static class Xor_N
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_N);
        private Expression argument;

        public Xor_N(Expression arguments) {
            this.argument = arguments;
        }

        @Override
        public int getSize(Scope context) {
            return 2;
        }

        @Override
        public byte[] getBytes(Scope context) {
            return new byte[]{-18, (byte)this.argument.getInteger()};
        }
    }

    public static class Xor_R
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_R_INDIRECT_HL_IX_IY);
        private Expression argument;

        public Xor_R(Expression arguments) {
            this.argument = arguments;
        }

        @Override
        public int getSize(Scope context) {
            return this.indexifyIndirect(this.argument.getRegister(), 1);
        }

        @Override
        public byte[] getBytes(Scope context) {
            Register register = this.argument.getRegister();
            return this.indexifyIndirect(register, (byte)(0xA8 | register.get8BitCode()));
        }
    }
}

