/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.Line;
import nl.grauw.glass.LineParser;
import nl.grauw.glass.Scope;
import nl.grauw.glass.Source;
import nl.grauw.glass.directives.Directive;
import nl.grauw.glass.directives.Equ;
import nl.grauw.glass.directives.If;
import nl.grauw.glass.directives.Include;
import nl.grauw.glass.directives.Instruction;
import nl.grauw.glass.directives.Irp;
import nl.grauw.glass.directives.Macro;
import nl.grauw.glass.directives.Proc;
import nl.grauw.glass.directives.Rept;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Sequence;

public class SourceParser {
    public static final List<String> END_TERMINATORS = Arrays.asList("end", "END");
    public static final List<String> ENDM_TERMINATORS = Arrays.asList("endm", "ENDM");
    public static final List<String> ENDP_TERMINATORS = Arrays.asList("endp", "ENDP");
    public static final List<String> ELSE_TERMINATORS = Arrays.asList("else", "ELSE", "endif", "ENDIF");
    public static final List<String> ENDIF_TERMINATORS = Arrays.asList("endif", "ENDIF");
    private final Source source;
    private final List<String> terminators;
    private final List<File> includePaths = new ArrayList<File>();
    private final LineParser lineParser = new LineParser();

    public SourceParser(List<File> includePaths) {
        this.source = new Source();
        this.terminators = END_TERMINATORS;
        this.includePaths.add(null);
        this.includePaths.addAll(includePaths);
    }

    public SourceParser(Scope scope, List<String> terminators, List<File> includePaths) {
        this.source = new Source(scope);
        this.terminators = terminators;
        this.includePaths.add(null);
        this.includePaths.addAll(includePaths);
    }

    public Source parse(File sourceFile) {
        try {
            this.parse(new FileInputStream(sourceFile), sourceFile);
        }
        catch (FileNotFoundException e) {
            throw new AssemblyException(e);
        }
        return this.source;
    }

    private Source parseInclude(File sourceFile) {
        for (File includePath : this.includePaths) {
            File fullPath = new File(includePath, sourceFile.getPath());
            if (!fullPath.exists()) continue;
            this.parse(fullPath);
            return this.source;
        }
        throw new AssemblyException("Include file not found: " + sourceFile);
    }

    public Source parse(InputStream reader, File sourceFile) {
        return this.parse(new InputStreamReader(reader, Charset.forName("ISO-8859-1")), sourceFile);
    }

    public Source parse(Reader reader, File sourceFile) {
        return this.parse(new LineNumberReader(reader), sourceFile);
    }

    /*
     * Exception decompiling
     */
    private Source parse(LineNumberReader reader, File sourceFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Directive getDirective(Line line, LineNumberReader reader, File sourceFile) {
        if (line.getMnemonic() == null) {
            return new Instruction();
        }
        switch (line.getMnemonic()) {
            case "equ": 
            case "EQU": {
                return new Equ();
            }
            case "include": 
            case "INCLUDE": {
                return this.getIncludeDirective(line);
            }
            case "macro": 
            case "MACRO": {
                return new Macro(this.parseBlock(line.getScope(), ENDM_TERMINATORS, reader, sourceFile));
            }
            case "rept": 
            case "REPT": {
                return new Rept(this.parseBlock(line.getScope(), ENDM_TERMINATORS, reader, sourceFile));
            }
            case "irp": 
            case "IRP": {
                return new Irp(this.parseBlock(line.getScope(), ENDM_TERMINATORS, reader, sourceFile));
            }
            case "proc": 
            case "PROC": {
                return new Proc(this.parseBlock(line.getScope(), ENDP_TERMINATORS, reader, sourceFile));
            }
            case "if": 
            case "IF": {
                Source thenBlock = this.parseBlock(this.source.getScope(), ELSE_TERMINATORS, reader, sourceFile);
                Source elseBlock = !ENDIF_TERMINATORS.contains(thenBlock.getLastLine().getMnemonic()) ? this.parseBlock(this.source.getScope(), ENDIF_TERMINATORS, reader, sourceFile) : null;
                return new If(thenBlock, elseBlock);
            }
        }
        return new Instruction();
    }

    private Directive getIncludeDirective(Line line) {
        if (line.getArguments() instanceof Sequence) {
            throw new AssemblyException("Include only accepts 1 argument.");
        }
        Expression argument = line.getArguments();
        if (!argument.isString()) {
            throw new AssemblyException("A string literal is expected.");
        }
        this.parseInclude(new File(argument.getString()));
        return new Include();
    }

    private Source parseBlock(Scope scope, List<String> terminators, LineNumberReader reader, File sourceFile) {
        return new SourceParser(scope, terminators, this.includePaths).parse(reader, sourceFile);
    }
}

