/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.EvaluationException;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Flag;
import nl.grauw.glass.expressions.Register;

public class Identifier
extends Expression {
    private Context context;
    private final String name;

    public Identifier(String name, Context context) {
        this.name = name;
        this.context = context;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Expression copy(Context context) {
        return new Identifier(this.name, context);
    }

    public Expression resolve() {
        return this.context.getSymbol(this.name);
    }

    @Override
    public boolean isInteger() {
        return this.resolve().isInteger();
    }

    @Override
    public int getInteger() {
        return this.resolve().getInteger();
    }

    @Override
    public boolean isRegister() {
        return Register.getByName(this.name) != null;
    }

    @Override
    public Register getRegister() {
        Register register = Register.getByName(this.name);
        if (register != null) {
            return register;
        }
        throw new EvaluationException("Currently not supported.");
    }

    @Override
    public boolean isFlag() {
        return Flag.getByName(this.name) != null;
    }

    @Override
    public Flag getFlag() {
        Flag flag = Flag.getByName(this.name);
        if (flag != null) {
            return flag;
        }
        throw new EvaluationException("Currently not supported.");
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String toDebugString() {
        return this.toString();
    }
}

