/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Literal;

public class IntegerLiteral
extends Literal {
    public static final IntegerLiteral ZERO = new IntegerLiteral(0);
    public static final IntegerLiteral ONE = new IntegerLiteral(1);
    private final int value;

    public IntegerLiteral(int value) {
        this.value = value;
    }

    @Override
    public Expression copy(Context context) {
        return this;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public int getInteger() {
        return this.value;
    }

    public String toString() {
        String string = Integer.toHexString(this.value).toUpperCase();
        return (string.charAt(0) >= 'A' && string.charAt(0) <= 'F' ? "0" : "") + string + "H";
    }

    @Override
    public String toDebugString() {
        return this.toString();
    }
}

