/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import nl.grauw.glass.Scope;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Schema;
import nl.grauw.glass.instructions.ArgumentException;
import nl.grauw.glass.instructions.Instruction;
import nl.grauw.glass.instructions.InstructionObject;

public class Jr
extends Instruction {
    @Override
    public InstructionObject createObject(Expression arguments) {
        if (Jr_F_N.ARGUMENTS.check(arguments)) {
            return new Jr_F_N(arguments.getElement(0), arguments.getElement(1));
        }
        if (Jr_N.ARGUMENTS.check(arguments)) {
            return new Jr_N(arguments.getElement(0));
        }
        throw new ArgumentException();
    }

    public static class Jr_F_N
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(new Schema.IsFlagZC(), Schema.DIRECT_N);
        private Expression argument1;
        private Expression argument2;

        public Jr_F_N(Expression argument1, Expression argument2) {
            this.argument1 = argument1;
            this.argument2 = argument2;
        }

        @Override
        public int getSize(Scope context) {
            return 2;
        }

        @Override
        public byte[] getBytes(Scope context) {
            int offset = this.argument2.getAddress() - (context.getAddress() + 2);
            if (offset < -128 || offset > 127) {
                throw new ArgumentException("Jump offset out of range: " + offset);
            }
            return new byte[]{(byte)(0x20 | this.argument1.getFlag().getCode() << 3), (byte)offset};
        }
    }

    public static class Jr_N
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_N);
        private Expression argument;

        public Jr_N(Expression argument) {
            this.argument = argument;
        }

        @Override
        public int getSize(Scope context) {
            return 2;
        }

        @Override
        public byte[] getBytes(Scope context) {
            int offset = this.argument.getAddress() - (context.getAddress() + 2);
            if (offset < -128 || offset > 127) {
                throw new ArgumentException("Jump offset out of range: " + offset);
            }
            return new byte[]{24, (byte)offset};
        }
    }
}

