/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.ContextLiteral;
import nl.grauw.glass.expressions.EvaluationException;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.instructions.Instruction;

public class Scope
implements Context {
    private final Scope parent;
    private final Map<String, Expression> variables = new HashMap<String, Expression>();
    private final Map<String, Instruction> instructions = new HashMap<String, Instruction>();
    private int address = -1;

    public Scope() {
        this(null);
    }

    public Scope(Scope parent) {
        this.parent = parent;
        this.addSymbol("$", this);
    }

    public Scope getParent() {
        return this.parent;
    }

    @Override
    public int getAddress() {
        if (this.address == -1) {
            throw new EvaluationException("Address not initialized.");
        }
        return this.address;
    }

    public void setAddress(int address) {
        if (this.address != -1) {
            throw new AssemblyException("Address was already set.");
        }
        if (address < 0 || address >= 65536) {
            throw new AssemblyException("Address out of range: " + Integer.toHexString(address) + "H");
        }
        this.address = address;
    }

    public void addSymbol(String name, Expression value) {
        if (name == null || value == null) {
            throw new AssemblyException("Symbol name and value must not be null.");
        }
        if (this.variables.containsKey(name)) {
            throw new AssemblyException("Can not redefine symbol: " + name);
        }
        this.variables.put(name, value);
    }

    public void addSymbol(String name, Scope context) {
        this.addSymbol(name, new ContextLiteral(context));
    }

    @Override
    public boolean hasSymbol(String name) {
        return this.getLocalSymbol(name) != null || this.parent != null && this.parent.hasSymbol(name);
    }

    @Override
    public Expression getSymbol(String name) {
        Expression value = this.getLocalSymbol(name);
        if (value != null) {
            return value;
        }
        if (this.parent != null) {
            return this.parent.getSymbol(name);
        }
        throw new SymbolNotFoundException(name);
    }

    private Expression getLocalSymbol(String name) {
        Expression value = this.variables.get(name);
        if (value != null) {
            return value;
        }
        int index = name.length();
        while ((index = name.lastIndexOf(46, index - 1)) != -1) {
            Expression result = this.variables.get(name.substring(0, index));
            if (!(result instanceof ContextLiteral)) continue;
            return ((Scope)((ContextLiteral)result).getContext()).getLocalSymbol(name.substring(index + 1));
        }
        return null;
    }

    public Instruction addInstruction(String mnemonic, Instruction factory) {
        if (mnemonic == null || factory == null) {
            throw new AssemblyException("Instruction mnemonic and factory must not be null.");
        }
        if (this.instructions.containsKey(mnemonic)) {
            throw new AssemblyException("Instruction already registered.");
        }
        this.instructions.put(mnemonic, factory);
        return factory;
    }

    public Instruction getInstruction(String mnemonic) {
        Instruction factory = this.instructions.get(mnemonic);
        if (factory != null) {
            return factory;
        }
        if (this.parent != null) {
            return this.parent.getInstruction(mnemonic);
        }
        throw new AssemblyException("Unrecognized mnemonic.");
    }

    public String serializeSymbols() {
        return this.serializeSymbols("");
    }

    public String serializeSymbols(String namePrefix) {
        StringBuilder builder = new StringBuilder();
        TreeMap<String, Expression> sortedMap = new TreeMap<String, Expression>(this.variables);
        for (Map.Entry<String, Expression> entry : sortedMap.entrySet()) {
            if (!(entry.getValue() instanceof ContextLiteral) || "$".equals(entry.getKey())) continue;
            String name = namePrefix + entry.getKey();
            try {
                builder.append(name + ": equ " + entry.getValue().getHexValue() + "\n");
            }
            catch (EvaluationException e) {
                // empty catch block
            }
            Scope context = (Scope)((ContextLiteral)entry.getValue()).getContext();
            builder.append(context.serializeSymbols(name + "."));
        }
        return builder.toString();
    }

    public String toString() {
        return this.serializeSymbols();
    }

    public static class SymbolNotFoundException
    extends AssemblyException {
        private static final long serialVersionUID = 1L;

        public SymbolNotFoundException(String name) {
            super("Symbol not found: " + name);
        }
    }
}

