/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import java.util.List;
import nl.grauw.glass.expressions.BinaryOperator;
import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.Expression;

public class Sequence
extends BinaryOperator {
    public Sequence(Expression value, Expression tail) {
        super(value, tail);
    }

    public Expression getValue() {
        return this.term1;
    }

    public Expression getTail() {
        return this.term2;
    }

    @Override
    public Expression copy(Context context) {
        return new Sequence(this.term1.copy(context), this.term2.copy(context));
    }

    @Override
    protected void addToList(List<Expression> list) {
        this.term1.addToList(list);
        for (Expression tail = this.term2; tail != null; tail = tail.getNext()) {
            tail.getElement().addToList(list);
        }
    }

    @Override
    public Expression getElement(int index) {
        return index == 0 ? this.term1 : this.term2.getElement(index - 1);
    }

    @Override
    public Expression getNext() {
        return this.term2;
    }

    @Override
    public String getSymbol() {
        return ",";
    }

    @Override
    public String toString() {
        return "" + this.term1 + ", " + this.term2;
    }

    @Override
    public String toDebugString() {
        return "{" + this.term1.toDebugString() + ", " + this.term2.toDebugString() + "}";
    }
}

