/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.Scope;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Identifier;
import nl.grauw.glass.expressions.IntegerLiteral;
import nl.grauw.glass.expressions.Schema;
import nl.grauw.glass.instructions.ArgumentException;
import nl.grauw.glass.instructions.Instruction;
import nl.grauw.glass.instructions.InstructionObject;
import nl.grauw.glass.instructions.Section;

public class Ds
extends Instruction {
    public static Schema ARGUMENTS_N = new Schema(new Schema.IsAnnotation(Schema.INTEGER));
    public static Schema ARGUMENTS_N_N = new Schema(Schema.INTEGER, Schema.INTEGER);
    private final List<Section> sections = new ArrayList<Section>();

    public void addSection(Section section) {
        this.sections.add(section);
    }

    @Override
    public InstructionObject createObject(Expression arguments) {
        if (ARGUMENTS_N.check(arguments)) {
            return new Ds_N_N(arguments.getElement(0).getAnnotation(), arguments.getElement(0).getAnnotee(), IntegerLiteral.ZERO);
        }
        if (ARGUMENTS_N_N.check(arguments)) {
            return new Ds_N_N(null, arguments.getElement(0), arguments.getElement(1));
        }
        throw new ArgumentException();
    }

    public class Ds_N_N
    extends InstructionObject {
        private final boolean virtual;
        private final Expression size;
        private final Expression value;

        public Ds_N_N(Identifier annotation, Expression size, Expression value) {
            this.virtual = annotation != null && ("virtual".equals(annotation.getName()) || "VIRTUAL".equals(annotation.getName()));
            this.size = size;
            this.value = value;
            if (annotation != null && !this.virtual) {
                throw new ArgumentException("Unsupported annotation: " + annotation.getName());
            }
        }

        @Override
        public int resolve(Scope context, int address) {
            int innerAddress = address;
            for (Section section : Ds.this.sections) {
                innerAddress = section.getSource().resolve(innerAddress);
            }
            return super.resolve(context, address);
        }

        @Override
        public int getSize(Scope context) {
            return this.size.getInteger();
        }

        @Override
        public void generateObjectCode(Scope context, OutputStream output) throws IOException {
            byte[] bytes = this.getSectionBytes();
            if (bytes.length > this.size.getInteger()) {
                throw new AssemblyException("Section size exceeds space.");
            }
            if (this.virtual) {
                return;
            }
            output.write(bytes);
            byte[] padding = new byte[this.size.getInteger() - bytes.length];
            Arrays.fill(padding, (byte)this.value.getInteger());
            output.write(padding);
        }

        public byte[] getSectionBytes() throws IOException {
            ByteArrayOutputStream sourceByteStream = new ByteArrayOutputStream(this.size.getInteger());
            for (Section section : Ds.this.sections) {
                section.getSource().generateObjectCode(sourceByteStream);
            }
            return sourceByteStream.toByteArray();
        }

        @Override
        public byte[] getBytes(Scope context) {
            if (this.virtual) {
                return new byte[0];
            }
            byte[] bytes = new byte[this.size.getInteger()];
            Arrays.fill(bytes, (byte)this.value.getInteger());
            return bytes;
        }
    }
}

