/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import nl.grauw.glass.Scope;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Register;
import nl.grauw.glass.expressions.Schema;
import nl.grauw.glass.instructions.ArgumentException;
import nl.grauw.glass.instructions.Instruction;
import nl.grauw.glass.instructions.InstructionObject;

public class In
extends Instruction {
    @Override
    public InstructionObject createObject(Expression arguments) {
        if (In_N_C.ARGUMENTS.check(arguments)) {
            return new In_N_C(arguments.getElement(0));
        }
        if (In_N_C.ARGUMENTS_NO_R.check(arguments)) {
            return new In_N_C(Register.HL);
        }
        if (In_N_N.ARGUMENTS.check(arguments)) {
            return new In_N_N(arguments.getElement(1));
        }
        throw new ArgumentException();
    }

    public static class In_N_N
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_A, Schema.INDIRECT_N);
        private Expression argument;

        public In_N_N(Expression arguments) {
            this.argument = arguments;
        }

        @Override
        public int getSize(Scope context) {
            return 2;
        }

        @Override
        public byte[] getBytes(Scope context) {
            return new byte[]{-37, (byte)this.argument.getInteger()};
        }
    }

    public static class In_N_C
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_R, Schema.INDIRECT_C);
        public static Schema ARGUMENTS_NO_R = new Schema(Schema.INDIRECT_C);
        private Expression argument;

        public In_N_C(Expression arguments) {
            this.argument = arguments;
        }

        @Override
        public int getSize(Scope context) {
            return 2;
        }

        @Override
        public byte[] getBytes(Scope context) {
            return new byte[]{-19, (byte)(0x40 | this.argument.getRegister().get8BitCode() << 3)};
        }
    }
}

