/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Flag;
import nl.grauw.glass.expressions.Register;

public class Identifier
extends Expression {
    private Context context;
    private final String name;

    public Identifier(String name, Context context) {
        this.name = name;
        this.context = context;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Expression copy(Context context) {
        return new Identifier(this.name, context);
    }

    public boolean exists() {
        return this.context.hasSymbol(this.name);
    }

    public Expression resolve() {
        return this.context.getSymbol(this.name);
    }

    @Override
    public boolean isInteger() {
        return this.resolve().isInteger();
    }

    @Override
    public int getInteger() {
        return this.resolve().getInteger();
    }

    @Override
    public boolean isRegister() {
        Register register = Register.getByName(this.name);
        return register != null || this.exists() && this.resolve().isRegister();
    }

    @Override
    public Register getRegister() {
        Register register = Register.getByName(this.name);
        return register != null ? register : this.resolve().getRegister();
    }

    @Override
    public boolean isFlag() {
        Flag flag = Flag.getByName(this.name);
        return flag != null || this.exists() && this.resolve().isFlag();
    }

    @Override
    public Flag getFlag() {
        Flag flag = Flag.getByName(this.name);
        return flag != null ? flag : this.resolve().getFlag();
    }

    @Override
    public boolean isGroup() {
        return this.exists() && this.resolve().isGroup();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String toDebugString() {
        return this.toString();
    }
}

