/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.EvaluationException;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.IntegerLiteral;
import nl.grauw.glass.expressions.Literal;

public class Register
extends Literal {
    public static final int NONE = -1;
    public static final int IX_CODE = 221;
    public static final int IY_CODE = 253;
    public static Register B = new Register("b", false, 0, -1, -1);
    public static Register C = new Register("c", false, 1, -1, -1);
    public static Register D = new Register("d", false, 2, -1, -1);
    public static Register E = new Register("e", false, 3, -1, -1);
    public static Register H = new Register("h", false, 4, -1, -1);
    public static Register L = new Register("l", false, 5, -1, -1);
    public static Register A = new Register("a", false, 7, -1, -1);
    public static Register IXH = new Register("ixh", false, 4, -1, 221);
    public static Register IXL = new Register("ixl", false, 5, -1, 221);
    public static Register IYH = new Register("iyh", false, 4, -1, 253);
    public static Register IYL = new Register("iyl", false, 5, -1, 253);
    public static Register BC = new Register("bc", true, -1, 0, -1);
    public static Register DE = new Register("de", true, -1, 1, -1);
    public static Register HL = new Register("hl", true, 6, 2, -1);
    public static Register SP = new Register("sp", true, -1, 3, -1);
    public static Register AF = new Register("af", true, -1, 3, -1);
    public static Register AF_ = new Register("af'", true, -1, -1, -1);
    public static Register IX = new Register("ix", true, 6, 2, 221, IntegerLiteral.ZERO);
    public static Register IY = new Register("iy", true, 6, 2, 253, IntegerLiteral.ZERO);
    public static Register I = new Register("i", false, -1, -1, -1);
    public static Register R = new Register("r", false, -1, -1, -1);
    private final String name;
    private final boolean pair;
    private final int code8;
    private final int code16;
    private final int indexCode;
    private final Expression indexOffset;

    public Register(String name, boolean pair, int code8, int code16, int indexCode) {
        this(name, pair, code8, code16, indexCode, null);
    }

    public Register(String name, boolean pair, int code8, int code16, int indexCode, Expression offset) {
        if (!(offset == null || pair && indexCode != -1)) {
            throw new AssemblyException("Can only specify offset for 16-bit index registers.");
        }
        this.name = name;
        this.pair = pair;
        this.code8 = code8;
        this.code16 = code16;
        this.indexCode = indexCode;
        this.indexOffset = offset;
    }

    public Register(Register register, Expression offset) {
        this(register.name, register.pair, register.code8, register.code16, register.indexCode, offset);
    }

    public boolean isPair() {
        return this.pair;
    }

    public int get8BitCode() {
        if (this.code8 == -1) {
            throw new EvaluationException("Register does not have an 8-bit code.");
        }
        return this.code8;
    }

    public int get16BitCode() {
        if (this.code16 == -1) {
            throw new EvaluationException("Register does not have a 16-bit code.");
        }
        return this.code16;
    }

    public boolean isIndex() {
        return this.indexCode != -1;
    }

    public byte getIndexCode() {
        if (this.indexCode == -1) {
            throw new EvaluationException("Not an index register.");
        }
        return (byte)this.indexCode;
    }

    public Expression getIndexOffset() {
        if (this.indexCode == -1 || !this.pair) {
            throw new EvaluationException("Not an index register pair.");
        }
        return this.indexOffset;
    }

    @Override
    public Expression copy(Context context) {
        return this;
    }

    @Override
    public boolean isRegister() {
        return true;
    }

    @Override
    public Register getRegister() {
        return this;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String toDebugString() {
        return this.toString();
    }

    public static Register getByName(String name) {
        switch (name) {
            case "b": 
            case "B": {
                return B;
            }
            case "c": 
            case "C": {
                return C;
            }
            case "d": 
            case "D": {
                return D;
            }
            case "e": 
            case "E": {
                return E;
            }
            case "h": 
            case "H": {
                return H;
            }
            case "l": 
            case "L": {
                return L;
            }
            case "a": 
            case "A": {
                return A;
            }
            case "ixh": 
            case "IXH": {
                return IXH;
            }
            case "ixl": 
            case "IXL": {
                return IXL;
            }
            case "iyh": 
            case "IYH": {
                return IYH;
            }
            case "iyl": 
            case "IYL": {
                return IYL;
            }
            case "bc": 
            case "BC": {
                return BC;
            }
            case "de": 
            case "DE": {
                return DE;
            }
            case "hl": 
            case "HL": {
                return HL;
            }
            case "sp": 
            case "SP": {
                return SP;
            }
            case "af": 
            case "AF": {
                return AF;
            }
            case "af'": 
            case "AF'": {
                return AF_;
            }
            case "ix": 
            case "IX": {
                return IX;
            }
            case "iy": 
            case "IY": {
                return IY;
            }
            case "i": 
            case "I": {
                return I;
            }
            case "r": 
            case "R": {
                return R;
            }
        }
        return null;
    }
}

