/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import nl.grauw.glass.Scope;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Register;
import nl.grauw.glass.expressions.Schema;
import nl.grauw.glass.instructions.ArgumentException;
import nl.grauw.glass.instructions.Instruction;
import nl.grauw.glass.instructions.InstructionObject;

public class Add
extends Instruction {
    @Override
    public InstructionObject createObject(Expression arguments) {
        if (Add_A_R.ARGUMENTS.check(arguments)) {
            return new Add_A_R(arguments.getElement(1));
        }
        if (Add_A_N.ARGUMENTS.check(arguments)) {
            return new Add_A_N(arguments.getElement(1));
        }
        if (Add_HL_RR.ARGUMENTS.check(arguments)) {
            return new Add_HL_RR(arguments.getElement(0).getRegister(), arguments.getElement(1).getRegister());
        }
        throw new ArgumentException();
    }

    public static class Add_HL_RR
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_HL_IX_IY, Schema.DIRECT_RR_INDEX);
        private Register register1;
        private Register register2;

        public Add_HL_RR(Register register1, Register register2) {
            this.register1 = register1;
            this.register2 = register2;
            if (register1.get16BitCode() == register2.get16BitCode() && register1 != register2) {
                throw new ArgumentException();
            }
        }

        @Override
        public int getSize(Scope context) {
            return this.indexifyDirect(this.register1.getRegister(), 1);
        }

        @Override
        public byte[] getBytes(Scope context) {
            return this.indexifyDirect(this.register1.getRegister(), (byte)(9 | this.register2.getRegister().get16BitCode() << 4));
        }
    }

    public static class Add_A_N
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_A, Schema.DIRECT_N);
        private Expression argument;

        public Add_A_N(Expression arguments) {
            this.argument = arguments;
        }

        @Override
        public int getSize(Scope context) {
            return 2;
        }

        @Override
        public byte[] getBytes(Scope context) {
            return new byte[]{-58, (byte)this.argument.getInteger()};
        }
    }

    public static class Add_A_R
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_A, Schema.DIRECT_R_INDIRECT_HL_IX_IY);
        private Expression argument;

        public Add_A_R(Expression arguments) {
            this.argument = arguments;
        }

        @Override
        public int getSize(Scope context) {
            return this.indexifyIndirect(this.argument.getRegister(), 1);
        }

        @Override
        public byte[] getBytes(Scope context) {
            Register register = this.argument.getRegister();
            return this.indexifyIndirect(register, (byte)(0x80 | register.get8BitCode()));
        }
    }
}

