/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import nl.grauw.glass.Scope;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Schema;
import nl.grauw.glass.instructions.ArgumentException;
import nl.grauw.glass.instructions.Instruction;
import nl.grauw.glass.instructions.InstructionObject;

public class Ex
extends Instruction {
    @Override
    public InstructionObject createObject(Expression arguments) {
        if (Ex_AF.ARGUMENTS.check(arguments)) {
            return new Ex_AF();
        }
        if (Ex_DE_HL.ARGUMENTS.check(arguments)) {
            return new Ex_DE_HL();
        }
        if (Ex_SP.ARGUMENTS.check(arguments)) {
            return new Ex_SP(arguments.getElement(1));
        }
        throw new ArgumentException();
    }

    public static class Ex_SP
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.INDIRECT_SP, Schema.DIRECT_HL_IX_IY);
        private Expression argument;

        public Ex_SP(Expression argument) {
            this.argument = argument;
        }

        @Override
        public int getSize(Scope context) {
            return this.indexifyDirect(this.argument.getRegister(), 1);
        }

        @Override
        public byte[] getBytes(Scope context) {
            return this.indexifyDirect(this.argument.getRegister(), (byte)-29);
        }
    }

    public static class Ex_DE_HL
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_DE, Schema.DIRECT_HL);

        @Override
        public int getSize(Scope context) {
            return 1;
        }

        @Override
        public byte[] getBytes(Scope context) {
            return new byte[]{-21};
        }
    }

    public static class Ex_AF
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_AF, Schema.DIRECT_AF_);

        @Override
        public int getSize(Scope context) {
            return 1;
        }

        @Override
        public byte[] getBytes(Scope context) {
            return new byte[]{8};
        }
    }
}

