/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import java.util.List;
import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.Line;
import nl.grauw.glass.Scope;
import nl.grauw.glass.Source;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Identifier;
import nl.grauw.glass.expressions.IntegerLiteral;
import nl.grauw.glass.instructions.ArgumentException;
import nl.grauw.glass.instructions.Empty;
import nl.grauw.glass.instructions.Instruction;
import nl.grauw.glass.instructions.InstructionObject;

public class Macro
extends Instruction {
    private final Source source;
    private final Scope parameterScope;

    public Macro(Source source) {
        this.source = new Source(source.getScope());
        this.parameterScope = new Scope(source.getScope());
        this.source.addLines(source.getLineCopies(this.parameterScope));
        this.source.register();
    }

    @Override
    public List<Line> expand(Line line) {
        for (Expression parameters = line.getArguments(); parameters != null; parameters = parameters.getNext()) {
            Expression parameter = parameters.getElement();
            if (!(parameter instanceof Identifier)) {
                throw new ArgumentException("Parameter must be an identifier.");
            }
            this.parameterScope.addSymbol(((Identifier)parameter).getName(), IntegerLiteral.ZERO);
        }
        try {
            this.source.expand();
        }
        catch (AssemblyException assemblyException) {
            // empty catch block
        }
        return super.expand(line);
    }

    @Override
    public InstructionObject createObject(Expression arguments) {
        return new MacroObject();
    }

    public class MacroObject
    extends Empty.EmptyObject {
        @Override
        public int resolve(Scope context, int address) {
            try {
                Macro.this.source.resolve(0);
            }
            catch (AssemblyException assemblyException) {
                // empty catch block
            }
            return super.resolve(context, address);
        }
    }
}

