/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import java.util.List;
import nl.grauw.glass.Line;
import nl.grauw.glass.Source;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Schema;
import nl.grauw.glass.expressions.SchemaType;
import nl.grauw.glass.instructions.ArgumentException;
import nl.grauw.glass.instructions.Empty;
import nl.grauw.glass.instructions.Instruction;
import nl.grauw.glass.instructions.InstructionObject;

public class Proc
extends Instruction {
    public static Schema ARGUMENTS = new Schema(new SchemaType[0]);
    private final Source source;

    public Proc(Source source) {
        this.source = source;
    }

    @Override
    public List<Line> expand(Line line) {
        Expression arguments = line.getArguments();
        if (!ARGUMENTS.check(arguments)) {
            throw new ArgumentException();
        }
        List<Line> lines = super.expand(line);
        List<Line> lineCopies = this.source.getLineCopies(line.getScope());
        for (Line lineCopy : lineCopies) {
            lineCopy.register(line.getScope());
        }
        for (Line lineCopy : lineCopies) {
            lines.addAll(lineCopy.expand());
        }
        return lines;
    }

    @Override
    public InstructionObject createObject(Expression arguments) {
        return Empty.EmptyObject.INSTANCE;
    }
}

