/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.GlobalScope;
import nl.grauw.glass.Line;
import nl.grauw.glass.Scope;

public class Source {
    private final Scope scope;
    private List<Line> lines = new ArrayList<Line>();

    public Source() {
        this.scope = new GlobalScope();
    }

    public Source(Scope scope) {
        this.scope = scope;
    }

    public Source(Scope scope, Source other) {
        this(scope);
        for (Line line : other.lines) {
            this.addLine(new Line(new Scope(scope), line));
        }
    }

    public Scope getScope() {
        return this.scope;
    }

    public List<Line> getLines() {
        return this.lines;
    }

    public Line getLastLine() {
        return this.lines.size() > 0 ? this.lines.get(this.lines.size() - 1) : null;
    }

    public List<Line> getLineCopies(Scope newParent) {
        ArrayList<Line> lineCopies = new ArrayList<Line>();
        for (Line line : this.lines) {
            lineCopies.add(new Line(new Scope(newParent), line));
        }
        return lineCopies;
    }

    public Line addLine(Line line) {
        this.lines.add(line);
        return line;
    }

    public List<Line> addLines(List<Line> lines) {
        this.lines.addAll(lines);
        return lines;
    }

    public void assemble(OutputStream output) throws IOException {
        this.register();
        this.expand();
        this.resolve();
        this.generateObjectCode(output);
    }

    public void register() {
        for (Line line : this.lines) {
            line.register(this.scope);
        }
    }

    public void expand() {
        ArrayList<Line> newLines = new ArrayList<Line>();
        for (Line line : this.lines) {
            newLines.addAll(line.expand());
        }
        this.lines = newLines;
    }

    public int resolve() {
        return this.resolve(0);
    }

    public int resolve(int address) {
        for (Line line : this.lines) {
            address = line.resolve(address);
        }
        return address;
    }

    public void generateObjectCode(OutputStream output) throws IOException {
        for (Line line : this.lines) {
            line.generateObjectCode(output);
        }
    }

    public byte[] generateObjectCode() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            this.generateObjectCode(bytes);
        }
        catch (IOException e) {
            throw new AssemblyException(e);
        }
        return bytes.toByteArray();
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        for (Line line : this.lines) {
            string.append(line);
            string.append('\n');
        }
        return string.toString();
    }
}

