/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import nl.grauw.glass.Scope;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Register;
import nl.grauw.glass.expressions.Schema;
import nl.grauw.glass.instructions.ArgumentException;
import nl.grauw.glass.instructions.Instruction;
import nl.grauw.glass.instructions.InstructionObject;

public class Dec
extends Instruction {
    @Override
    public InstructionObject createObject(Scope context, Expression arguments) {
        if (Dec_R.ARGUMENTS.check(arguments)) {
            return new Dec_R(context, arguments.getElement(0));
        }
        if (Dec_RR.ARGUMENTS.check(arguments)) {
            return new Dec_RR(context, arguments.getElement(0));
        }
        throw new ArgumentException();
    }

    public static class Dec_RR
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_RR_INDEX);
        private Expression argument;

        public Dec_RR(Scope context, Expression arguments) {
            super(context);
            this.argument = arguments;
        }

        @Override
        public int getSize() {
            return this.indexifyDirect(this.argument.getRegister(), 1);
        }

        @Override
        public byte[] getBytes() {
            Register register = this.argument.getRegister();
            return this.indexifyDirect(register, (byte)(0xB | register.get16BitCode() << 4));
        }
    }

    public static class Dec_R
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_R_INDIRECT_HL_IX_IY);
        private Expression argument;

        public Dec_R(Scope context, Expression arguments) {
            super(context);
            this.argument = arguments;
        }

        @Override
        public int getSize() {
            return this.indexifyIndirect(this.argument.getRegister(), 1);
        }

        @Override
        public byte[] getBytes() {
            Register register = this.argument.getRegister();
            return this.indexifyIndirect(register, (byte)(5 | register.get8BitCode() << 3));
        }
    }
}

