/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import java.io.IOException;
import java.io.OutputStream;
import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.Scope;
import nl.grauw.glass.Source;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Schema;
import nl.grauw.glass.instructions.ArgumentException;
import nl.grauw.glass.instructions.Instruction;
import nl.grauw.glass.instructions.InstructionObject;

public class If
extends Instruction {
    private static Schema ARGUMENTS = new Schema(Schema.INTEGER);
    private final Source thenSource;
    private final Source elseSource;

    public If(Source thenSource, Source elseSource) {
        this.thenSource = thenSource;
        this.elseSource = elseSource;
    }

    @Override
    public InstructionObject createObject(Scope context, Expression arguments) {
        if (ARGUMENTS.check(arguments)) {
            return new IfObject(context, arguments);
        }
        throw new ArgumentException();
    }

    public class IfObject
    extends InstructionObject {
        private final Expression argument;

        public IfObject(Scope context, Expression argument) {
            super(context);
            this.argument = argument;
        }

        @Override
        public int resolve(int address) {
            this.context.setAddress(address);
            if (this.argument.getInteger() != 0) {
                If.this.thenSource.register();
                If.this.thenSource.expand();
                return If.this.thenSource.resolve(address);
            }
            if (If.this.elseSource != null) {
                If.this.elseSource.register();
                If.this.elseSource.expand();
                return If.this.elseSource.resolve(address);
            }
            return address;
        }

        @Override
        public int getSize() {
            throw new AssemblyException("Not implemented.");
        }

        @Override
        public void generateObjectCode(OutputStream output) throws IOException {
            if (this.argument.getInteger() != 0) {
                If.this.thenSource.generateObjectCode(output);
            } else if (If.this.elseSource != null) {
                If.this.elseSource.generateObjectCode(output);
            }
        }

        @Override
        public byte[] getBytes() {
            throw new AssemblyException("Not implemented.");
        }
    }
}

