/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import nl.grauw.glass.Line;

public class AssemblyException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final List<Context> contexts = new ArrayList<Context>();

    public AssemblyException() {
        this((Throwable)null);
    }

    public AssemblyException(String message) {
        this(message, null);
    }

    public AssemblyException(Throwable cause) {
        this("Error during assembly.", null);
    }

    public AssemblyException(String message, Throwable cause) {
        super(message, cause);
    }

    public void addContext(Line line) {
        this.addContext(line.getSourceFile(), line.getLineNumber(), -1, line.getSourceText());
    }

    public void addContext(File file, int line, int column, String text) {
        this.contexts.add(new Context(file, line, column, text));
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        for (Context context : this.contexts) {
            message = message + "\n" + context;
        }
        return message;
    }

    public String getPlainMessage() {
        return super.getMessage();
    }

    private static class Context {
        private final File file;
        private final int line;
        private final int column;
        private final String text;

        public Context(File file, int line, int column, String text) {
            this.file = file;
            this.line = line;
            this.column = column;
            this.text = text;
        }

        public String toString() {
            String prefix = "[at " + this.file + ":" + this.line + (this.column != -1 ? "," + this.column : "") + "]\n";
            String context = prefix + this.text;
            if (this.column >= 0) {
                int start = Math.min(context.lastIndexOf(10) + 1, context.length());
                int end = Math.min(start + this.column, context.length());
                context = context + "\n" + context.substring(start, end).replaceAll("[^\t]", " ") + "^";
            }
            return context;
        }
    }
}

