/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.Scope;
import nl.grauw.glass.directives.Directive;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.instructions.Empty;
import nl.grauw.glass.instructions.InstructionFactory;
import nl.grauw.glass.instructions.InstructionObject;

public class Line {
    private final Scope scope;
    private final String label;
    private final String mnemonic;
    private final Expression arguments;
    private final String comment;
    private final File sourceFile;
    private final int lineNumber;
    private final String sourceText;
    private InstructionFactory instruction;
    private InstructionObject instructionObject;
    private Directive directive;

    public Line(Scope scope, String label, String mnemonic, Expression arguments, String comment, File sourceFile, int lineNumber, String sourceText) {
        this.scope = scope;
        this.label = label;
        this.mnemonic = mnemonic;
        this.arguments = arguments;
        this.comment = comment;
        this.sourceFile = sourceFile;
        this.lineNumber = lineNumber;
        this.sourceText = sourceText;
    }

    public Line(Scope scope, Line other) {
        this(scope, other.label, other.mnemonic, other.arguments != null ? other.arguments.copy(scope) : null, other.comment, other.sourceFile, other.lineNumber, other.sourceText);
        this.directive = other.directive;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getLabel() {
        return this.label;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public Expression getArguments() {
        return this.arguments;
    }

    public String getComment() {
        return this.comment;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getSourceText() {
        return this.sourceText;
    }

    public void setDirective(Directive directive) {
        this.directive = directive;
    }

    public void setInstruction(InstructionFactory instruction) {
        this.instruction = instruction;
    }

    public InstructionFactory getInstruction() {
        if (this.instruction == null) {
            this.instruction = this.mnemonic != null ? this.scope.getSymbol(this.mnemonic).getInstruction() : Empty.INSTANCE;
        }
        return this.instruction;
    }

    public void register(Scope sourceScope) {
        try {
            this.directive.register(sourceScope, this);
        }
        catch (AssemblyException e) {
            e.addContext(this);
            throw e;
        }
    }

    public List<Line> expand() {
        try {
            return this.getInstruction().expand(this);
        }
        catch (AssemblyException e) {
            e.addContext(this);
            throw e;
        }
    }

    public int resolve(int address) {
        try {
            this.instructionObject = this.getInstruction().createObject(this.scope, this.arguments);
            return this.instructionObject.resolve(address);
        }
        catch (AssemblyException e) {
            e.addContext(this);
            throw e;
        }
    }

    public void generateObjectCode(OutputStream output) throws IOException {
        try {
            this.instructionObject.generateObjectCode(output);
        }
        catch (AssemblyException e) {
            e.addContext(this);
            throw e;
        }
    }

    public int getSize() {
        return this.instructionObject.getSize();
    }

    public byte[] getBytes() {
        return this.instructionObject.getBytes();
    }

    public String toString() {
        return (this.label != null ? this.label + ":" : "") + (this.mnemonic != null ? (this.label != null ? " " : "\t") + this.mnemonic + (this.arguments != null ? " " + this.arguments : "") : "") + (this.comment != null ? (this.label != null || this.mnemonic != null ? " ;" : ";") + this.comment : "");
    }
}

