/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass;

import java.io.File;
import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.Line;
import nl.grauw.glass.Scope;
import nl.grauw.glass.expressions.Expression;

public class LineBuilder {
    private String label;
    private String mnemonic;
    private Expression arguments;
    private String comment;
    private String sourceText;

    public void setLabel(String label) {
        if (this.label != null) {
            throw new AssemblyException("Label already set.");
        }
        this.label = label;
    }

    public void setMnemonic(String mnemonic) {
        if (this.mnemonic != null) {
            throw new AssemblyException("Mnemonic already set.");
        }
        this.mnemonic = mnemonic;
    }

    public void setArguments(Expression arguments) {
        if (this.arguments != null) {
            throw new AssemblyException("Arguments already set.");
        }
        this.arguments = arguments;
    }

    public void setComment(String comment) {
        this.comment = this.comment == null ? comment : this.comment + "\n" + comment;
    }

    public void setSourceText(String sourceText) {
        if (this.sourceText != null) {
            throw new AssemblyException("Source text already set.");
        }
        this.sourceText = sourceText;
    }

    public Line getLine(Scope scope, File sourceFile, int lineNumber) {
        Line line = new Line(scope, this.label, this.mnemonic, this.arguments, this.comment, sourceFile, lineNumber, this.sourceText);
        this.label = null;
        this.mnemonic = null;
        this.arguments = null;
        this.comment = null;
        this.sourceText = null;
        return line;
    }
}

