/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.expressions.BinaryOperator;
import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.EvaluationException;
import nl.grauw.glass.expressions.Expression;

public class Divide
extends BinaryOperator {
    public Divide(Expression dividend, Expression divisor) {
        super(dividend, divisor);
    }

    @Override
    public Divide copy(Context context) {
        return new Divide(this.term1.copy(context), this.term2.copy(context));
    }

    public Expression getDividend() {
        return this.term1;
    }

    public Expression getDivisor() {
        return this.term2;
    }

    @Override
    public int getInteger() {
        int divisor = this.term2.getInteger();
        if (divisor == 0) {
            throw new EvaluationException("Division by zero.");
        }
        return this.term1.getInteger() / divisor;
    }

    @Override
    public String getLexeme() {
        return "/";
    }
}

