/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import java.util.ArrayDeque;
import java.util.Deque;
import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.expressions.Add;
import nl.grauw.glass.expressions.And;
import nl.grauw.glass.expressions.Annotation;
import nl.grauw.glass.expressions.Complement;
import nl.grauw.glass.expressions.Divide;
import nl.grauw.glass.expressions.Equals;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.GreaterOrEquals;
import nl.grauw.glass.expressions.GreaterThan;
import nl.grauw.glass.expressions.Group;
import nl.grauw.glass.expressions.Identifier;
import nl.grauw.glass.expressions.IfElse;
import nl.grauw.glass.expressions.Index;
import nl.grauw.glass.expressions.LessOrEquals;
import nl.grauw.glass.expressions.LessThan;
import nl.grauw.glass.expressions.LogicalAnd;
import nl.grauw.glass.expressions.LogicalOr;
import nl.grauw.glass.expressions.Member;
import nl.grauw.glass.expressions.Modulo;
import nl.grauw.glass.expressions.Multiply;
import nl.grauw.glass.expressions.Negative;
import nl.grauw.glass.expressions.Not;
import nl.grauw.glass.expressions.NotEquals;
import nl.grauw.glass.expressions.Or;
import nl.grauw.glass.expressions.Positive;
import nl.grauw.glass.expressions.Sequence;
import nl.grauw.glass.expressions.ShiftLeft;
import nl.grauw.glass.expressions.ShiftRight;
import nl.grauw.glass.expressions.Subtract;
import nl.grauw.glass.expressions.Xor;

public class ExpressionBuilder {
    private Deque<Expression> operands = new ArrayDeque<Expression>();
    private Deque<Operator> operators = new ArrayDeque<Operator>();
    private int groupCount = 0;
    public final Operator POSITIVE = new Operator(Precedence.UNARY, Associativity.RIGHT_TO_LEFT){

        @Override
        public Expression evaluate() {
            return new Positive((Expression)ExpressionBuilder.this.operands.pop());
        }
    };
    public final Operator NEGATIVE = new Operator(Precedence.UNARY, Associativity.RIGHT_TO_LEFT){

        @Override
        public Expression evaluate() {
            return new Negative((Expression)ExpressionBuilder.this.operands.pop());
        }
    };
    public final Operator COMPLEMENT = new Operator(Precedence.UNARY, Associativity.RIGHT_TO_LEFT){

        @Override
        public Expression evaluate() {
            return new Complement((Expression)ExpressionBuilder.this.operands.pop());
        }
    };
    public final Operator NOT = new Operator(Precedence.UNARY, Associativity.RIGHT_TO_LEFT){

        @Override
        public Expression evaluate() {
            return new Not((Expression)ExpressionBuilder.this.operands.pop());
        }
    };
    public final Operator MEMBER = new Operator(Precedence.MEMBER, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            if (!(operandRight instanceof Identifier)) {
                throw new ExpressionError("Member operator right hand side must be an identifier.");
            }
            return new Member((Expression)ExpressionBuilder.this.operands.pop(), (Identifier)operandRight);
        }
    };
    public final Operator MULTIPLY = new Operator(Precedence.MULTIPLICATION, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new Multiply((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator DIVIDE = new Operator(Precedence.MULTIPLICATION, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new Divide((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator MODULO = new Operator(Precedence.MULTIPLICATION, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new Modulo((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator ADD = new Operator(Precedence.ADDITION, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new Add((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator SUBTRACT = new Operator(Precedence.ADDITION, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new Subtract((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator SHIFT_LEFT = new Operator(Precedence.SHIFT, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new ShiftLeft((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator SHIFT_RIGHT = new Operator(Precedence.SHIFT, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new ShiftRight((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator LESS_THAN = new Operator(Precedence.COMPARISON, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new LessThan((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator LESS_OR_EQUALS = new Operator(Precedence.COMPARISON, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new LessOrEquals((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator GREATER_THAN = new Operator(Precedence.COMPARISON, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new GreaterThan((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator GREATER_OR_EQUALS = new Operator(Precedence.COMPARISON, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new GreaterOrEquals((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator EQUALS = new Operator(Precedence.EQUALITY, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new Equals((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator NOT_EQUALS = new Operator(Precedence.EQUALITY, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new NotEquals((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator AND = new Operator(Precedence.AND, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new And((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator XOR = new Operator(Precedence.XOR, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new Xor((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator OR = new Operator(Precedence.OR, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new Or((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator LOGICAL_AND = new Operator(Precedence.LOGICAL_AND, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new LogicalAnd((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator LOGICAL_OR = new Operator(Precedence.LOGICAL_OR, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new LogicalOr((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator ANNOTATION = new Operator(Precedence.ANNOTATION, Associativity.RIGHT_TO_LEFT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            Expression operandLeft = (Expression)ExpressionBuilder.this.operands.pop();
            if (!(operandLeft instanceof Identifier)) {
                throw new ExpressionError("Annotation left hand side must be an identifier.");
            }
            return new Annotation((Identifier)operandLeft, operandRight);
        }
    };
    public final Operator SEQUENCE = new Operator(Precedence.SEQUENCE, Associativity.RIGHT_TO_LEFT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new Sequence((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator TERNARYIF = new Operator(Precedence.TERNARYIFELSE, Associativity.RIGHT_TO_LEFT){

        @Override
        public Expression evaluate() {
            throw new ExpressionError("Ternary if (?) without else (:).");
        }
    };
    public final Operator TERNARYELSE = new Operator(Precedence.TERNARYIFELSE, Associativity.RIGHT_TO_LEFT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            while (ExpressionBuilder.this.operators.peek() == ExpressionBuilder.this.TERNARYELSE) {
                ExpressionBuilder.this.operands.push(((Operator)ExpressionBuilder.this.operators.pop()).evaluate());
            }
            if (ExpressionBuilder.this.operators.peek() == ExpressionBuilder.this.TERNARYIF) {
                ExpressionBuilder.this.operators.pop();
                Expression operandMiddle = (Expression)ExpressionBuilder.this.operands.pop();
                return new IfElse((Expression)ExpressionBuilder.this.operands.pop(), operandMiddle, operandRight);
            }
            throw new ExpressionError("Ternary else (:) without if (?).");
        }
    };
    public final Operator GROUP_OPEN = new Operator(Precedence.GROUPING, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            return new Group((Expression)ExpressionBuilder.this.operands.pop());
        }
    };
    public final Operator GROUP_CLOSE = new Operator(Precedence.NONE, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            throw new AssemblyException("Can not evaluate group close.");
        }
    };
    public final Operator INDEX_OPEN = new Operator(Precedence.MEMBER, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            return new Index((Expression)ExpressionBuilder.this.operands.pop(), operandRight);
        }
    };
    public final Operator INDEX_CLOSE = new Operator(Precedence.NONE, Associativity.LEFT_TO_RIGHT){

        @Override
        public Expression evaluate() {
            throw new AssemblyException("Can not evaluate group close.");
        }
    };
    public final Operator SENTINEL = new Operator(Precedence.NONE, Associativity.RIGHT_TO_LEFT){

        @Override
        public Expression evaluate() {
            throw new AssemblyException("Can not evaluate sentinel.");
        }
    };

    public ExpressionBuilder() {
        this.operators.push(this.SENTINEL);
    }

    public void addValueToken(Expression value) {
        this.operands.push(value);
    }

    public void addOperatorToken(Operator operator) {
        this.evaluateNotYieldingTo(operator);
        if (operator == this.GROUP_OPEN || operator == this.INDEX_OPEN) {
            ++this.groupCount;
            this.operators.push(operator);
            this.operators.push(this.SENTINEL);
        } else if (operator == this.GROUP_CLOSE || operator == this.INDEX_CLOSE) {
            --this.groupCount;
            if (this.operators.pop() != this.SENTINEL) {
                throw new AssemblyException("Sentinel expected.");
            }
            if (operator == this.GROUP_CLOSE && this.operators.peek() != this.GROUP_OPEN) {
                throw new ExpressionError("Group open expected.");
            }
            if (operator == this.INDEX_CLOSE && this.operators.peek() != this.INDEX_OPEN) {
                throw new ExpressionError("Index open expected.");
            }
        } else {
            this.operators.push(operator);
        }
    }

    public Expression getExpression() {
        if (this.operands.isEmpty() || this.operators.isEmpty()) {
            throw new AssemblyException("Operands / operators is empty: " + this);
        }
        this.evaluateNotYieldingTo(this.SENTINEL);
        if (this.operators.size() > 1 && this.operators.peek() == this.SENTINEL) {
            throw new ExpressionError("Group close expected.");
        }
        if (this.operands.size() > 1 || this.operators.size() != 1) {
            throw new AssemblyException("Not all operands / operators were processed: " + this);
        }
        return this.operands.pop();
    }

    private void evaluateNotYieldingTo(Operator operator) {
        while (!this.operators.peek().yieldsTo(operator)) {
            this.operands.push(this.operators.pop().evaluate());
        }
    }

    public boolean hasOpenGroup() {
        return this.groupCount > 0;
    }

    public String toString() {
        return "" + this.operands + " / " + this.operators;
    }

    public static class ExpressionError
    extends AssemblyException {
        private static final long serialVersionUID = 1L;

        public ExpressionError(String message) {
            super("Expression error: " + message);
        }
    }

    private static enum Associativity {
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT;

    }

    private static enum Precedence {
        GROUPING,
        MEMBER,
        UNARY,
        MULTIPLICATION,
        ADDITION,
        SHIFT,
        COMPARISON,
        EQUALITY,
        AND,
        XOR,
        OR,
        LOGICAL_AND,
        LOGICAL_OR,
        TERNARYIFELSE,
        ANNOTATION,
        SEQUENCE,
        NONE;

    }

    private abstract class Operator {
        private Precedence precedence;
        private Associativity associativity;

        private Operator(Precedence precedence, Associativity associativity) {
            this.precedence = precedence;
            this.associativity = associativity;
        }

        public boolean yieldsTo(Operator other) {
            if (this.associativity == Associativity.LEFT_TO_RIGHT) {
                return this.precedence.ordinal() > other.precedence.ordinal();
            }
            return this.precedence.ordinal() >= other.precedence.ordinal();
        }

        public abstract Expression evaluate();
    }
}

