/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.FlagOrRegister;
import nl.grauw.glass.expressions.Literal;
import nl.grauw.glass.expressions.Passthrough;

public class Identifier
extends Passthrough {
    private final String name;
    private final Context context;

    public Identifier(String name, Context context) {
        this.name = name;
        this.context = context;
    }

    @Override
    public Identifier copy(Context context) {
        return new Identifier(this.name, context);
    }

    public String getName() {
        return this.name;
    }

    public boolean exists() {
        return FlagOrRegister.getByName(this.name) != null || this.context.hasSymbol(this.name);
    }

    @Override
    public Expression resolve() {
        Literal flagOrRegister = FlagOrRegister.getByName(this.name);
        return flagOrRegister != null ? flagOrRegister : this.context.getSymbol(this.name);
    }

    @Override
    public boolean isRegister() {
        return this.exists() && super.isRegister();
    }

    @Override
    public boolean isFlag() {
        return this.exists() && super.isFlag();
    }

    @Override
    public boolean isGroup() {
        return this.exists() && super.isGroup();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String toDebugString() {
        return this.toString();
    }
}

