/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Passthrough;

public class IfElse
extends Passthrough {
    private final Expression condition;
    private final Expression trueTerm;
    private final Expression falseTerm;

    public IfElse(Expression condition, Expression trueTerm, Expression falseTerm) {
        this.condition = condition;
        this.trueTerm = trueTerm;
        this.falseTerm = falseTerm;
    }

    @Override
    public IfElse copy(Context context) {
        return new IfElse(this.condition.copy(context), this.trueTerm.copy(context), this.falseTerm.copy(context));
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getTrueTerm() {
        return this.trueTerm;
    }

    public Expression getFalseTerm() {
        return this.falseTerm;
    }

    public boolean isTrue() {
        return this.condition.getInteger() != 0;
    }

    @Override
    public Expression resolve() {
        return this.isTrue() ? this.trueTerm : this.falseTerm;
    }

    @Override
    public boolean isInteger() {
        return this.trueTerm.isInteger() && this.falseTerm.isInteger() || super.isInteger();
    }

    @Override
    public boolean isString() {
        return this.trueTerm.isString() && this.falseTerm.isString() || super.isString();
    }

    @Override
    public boolean isRegister() {
        return this.trueTerm.isRegister() && this.falseTerm.isRegister() || super.isRegister();
    }

    @Override
    public boolean isFlag() {
        return this.trueTerm.isFlag() && this.falseTerm.isFlag() || super.isFlag();
    }

    @Override
    public boolean isContext() {
        return this.trueTerm.isContext() && this.falseTerm.isContext() || super.isContext();
    }

    public String toString() {
        return "" + this.condition + " ? " + this.trueTerm + " : " + this.falseTerm;
    }

    @Override
    public String toDebugString() {
        return "{" + this.condition.toDebugString() + " ? " + this.trueTerm.toDebugString() + " : " + this.falseTerm.toDebugString() + "}";
    }
}

