/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Flag;
import nl.grauw.glass.expressions.UnaryOperator;

public class Not
extends UnaryOperator {
    public Not(Expression term) {
        super(term);
    }

    @Override
    public Not copy(Context context) {
        return new Not(this.term.copy(context));
    }

    @Override
    public int getInteger() {
        return this.term.getInteger() == 0 ? -1 : 0;
    }

    @Override
    public boolean isFlag() {
        return this.term.isFlag();
    }

    @Override
    public Flag getFlag() {
        Flag flag = this.term.getFlag();
        if (flag == Flag.NZ) {
            return Flag.Z;
        }
        if (flag == Flag.Z) {
            return Flag.NZ;
        }
        if (flag == Flag.NC) {
            return Flag.C;
        }
        if (flag == Flag.C) {
            return Flag.NC;
        }
        if (flag == Flag.PO) {
            return Flag.PE;
        }
        if (flag == Flag.PE) {
            return Flag.PO;
        }
        if (flag == Flag.P) {
            return Flag.M;
        }
        if (flag == Flag.M) {
            return Flag.P;
        }
        throw new AssemblyException("Unrecognised flag.");
    }

    @Override
    public String getLexeme() {
        return "!";
    }
}

