/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import java.util.List;
import nl.grauw.glass.expressions.CharacterLiteral;
import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.EvaluationException;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Literal;

public class StringLiteral
extends Literal {
    private final String string;

    public StringLiteral(String string) {
        this.string = string;
    }

    @Override
    public StringLiteral copy(Context context) {
        return this;
    }

    @Override
    public boolean isInteger() {
        return this.string.length() == 1;
    }

    @Override
    public int getInteger() {
        if (this.string.length() != 1) {
            throw new EvaluationException("Can not evaluate strings of more than 1 character to integer.");
        }
        return this.string.codePointAt(0);
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return this.string;
    }

    @Override
    protected void addToList(List<Expression> list) {
        int length = this.string.length();
        for (int i = 0; i < length; ++i) {
            list.add(new CharacterLiteral(this.string.charAt(i)));
        }
    }

    public String toString() {
        String escaped = this.string;
        escaped = escaped.replace("\\", "\\\\");
        escaped = escaped.replace("\"", "\\\"");
        escaped = escaped.replace("\u0000", "\\0");
        escaped = escaped.replace("\u0007", "\\a");
        escaped = escaped.replace("\t", "\\t");
        escaped = escaped.replace("\n", "\\n");
        escaped = escaped.replace("\f", "\\f");
        escaped = escaped.replace("\r", "\\r");
        escaped = escaped.replace("\u001b", "\\e");
        return "\"" + escaped + "\"";
    }

    @Override
    public String toDebugString() {
        return this.toString();
    }
}

