/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.expressions.BinaryOperator;
import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.EvaluationException;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Register;

public class Subtract
extends BinaryOperator {
    public Subtract(Expression minuend, Expression subtrahend) {
        super(minuend, subtrahend);
    }

    @Override
    public Subtract copy(Context context) {
        return new Subtract(this.term1.copy(context), this.term2.copy(context));
    }

    public Expression getMinuend() {
        return this.term1;
    }

    public Expression getSubtrahend() {
        return this.term2;
    }

    @Override
    public int getInteger() {
        return this.term1.getInteger() - this.term2.getInteger();
    }

    @Override
    public boolean isRegister() {
        if (this.term1.isRegister() && this.term2.isInteger()) {
            Register register = this.term1.getRegister();
            return register.isIndex() && register.isPair();
        }
        return false;
    }

    @Override
    public Register getRegister() {
        Register register;
        if (this.term1.isRegister() && this.term2.isInteger() && (register = this.term1.getRegister()).isIndex() && register.isPair()) {
            return new Register(register, new Subtract(register.getIndexOffset(), this.term2));
        }
        throw new EvaluationException("Not a register.");
    }

    @Override
    public String getLexeme() {
        return "-";
    }
}

