/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.ListingWriter;
import nl.grauw.glass.Source;
import nl.grauw.glass.SourceBuilder;

public class Assembler {
    private static Assembler instance;
    private final Source source;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(String.format("%s %s by %s", Assembler.class.getPackage().getImplementationTitle(), Assembler.class.getPackage().getImplementationVersion(), Assembler.class.getPackage().getImplementationVendor()));
            System.out.println();
            System.out.println("Usage: java -jar glass.jar [OPTION] SOURCE [OBJECT] [SYMBOL]");
            System.exit(1);
        }
        Path sourcePath = null;
        Path objectPath = null;
        Path symbolPath = null;
        Path listPath = null;
        ArrayList<Path> includePaths = new ArrayList<Path>();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-I")) {
                if (++i >= args.length) {
                    throw new AssemblyException("Missing argument value.");
                }
                includePaths.add(Paths.get(args[i], new String[0]));
            } else if (args[i].equals("-L")) {
                if (++i >= args.length) {
                    throw new AssemblyException("Missing argument value.");
                }
                listPath = Paths.get(args[i], new String[0]);
            } else if (sourcePath == null) {
                sourcePath = Paths.get(args[i], new String[0]);
            } else if (objectPath == null) {
                objectPath = Paths.get(args[i], new String[0]);
            } else if (symbolPath == null) {
                symbolPath = Paths.get(args[i], new String[0]);
            } else {
                throw new AssemblyException("Too many arguments.");
            }
            ++i;
        }
        instance = new Assembler(sourcePath, includePaths);
        instance.writeObject(objectPath);
        if (symbolPath != null) {
            instance.writeSymbols(symbolPath);
        }
        if (listPath != null) {
            instance.writeList(listPath);
        }
    }

    public Assembler(Path sourcePath, List<Path> includePaths) {
        this.source = new SourceBuilder(includePaths).parse(sourcePath);
    }

    public void writeObject(Path objectPath) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (OutputStream output = objectPath != null ? Assembler.createBufferedOutputStream(objectPath) : new NullOutputStream();){
                this.source.assemble(output);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeSymbols(Path symbolPath) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PrintStream symbolOutput = new PrintStream(Assembler.createBufferedOutputStream(symbolPath));){
                symbolOutput.print(this.source.getScope().serializeSymbols());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeList(Path listPath) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PrintStream output = new PrintStream(Assembler.createBufferedOutputStream(listPath));){
                new ListingWriter(output).write(this.source);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static OutputStream createBufferedOutputStream(Path path) throws IOException {
        return new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]), 65536);
    }

    public static class NullOutputStream
    extends OutputStream {
        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

