/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass;

import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.Line;
import nl.grauw.glass.LineBuilder;
import nl.grauw.glass.Scope;
import nl.grauw.glass.SourceFile;
import nl.grauw.glass.expressions.CharacterLiteral;
import nl.grauw.glass.expressions.ContextLiteral;
import nl.grauw.glass.expressions.ExpressionBuilder;
import nl.grauw.glass.expressions.Identifier;
import nl.grauw.glass.expressions.IntegerLiteral;
import nl.grauw.glass.expressions.StringLiteral;

public class Parser {
    private SourceFile.SourceFileReader reader;
    private Scope scope;
    private Scope lineScope;
    private LineBuilder lineBuilder = new LineBuilder();
    private State state;
    private StringBuilder accumulator = new StringBuilder();
    private ExpressionBuilder expressionBuilder = new ExpressionBuilder();
    private LabelStartState labelStartState = new LabelStartState();
    private LabelReadState labelReadState = new LabelReadState();
    private StatementStartState statementStartState = new StatementStartState();
    private StatementReadState statementReadState = new StatementReadState();
    private ArgumentStartState argumentStartState = new ArgumentStartState();
    private ArgumentValueState argumentValueState = new ArgumentValueState();
    private ArgumentIdentifierState argumentIdentifierState = new ArgumentIdentifierState();
    private ArgumentStringState argumentStringState = new ArgumentStringState();
    private ArgumentStringDoubleQuoteState argumentStringDoubleQuoteState = new ArgumentStringDoubleQuoteState();
    private ArgumentStringEscapeState argumentStringEscapeState = new ArgumentStringEscapeState();
    private ArgumentCharacterState argumentCharacterState = new ArgumentCharacterState();
    private ArgumentCharacterDoubleQuoteState argumentCharacterDoubleQuoteState = new ArgumentCharacterDoubleQuoteState();
    private ArgumentCharacterEscapeState argumentCharacterEscapeState = new ArgumentCharacterEscapeState();
    private ArgumentCharacterEndState argumentCharacterEndState = new ArgumentCharacterEndState();
    private ArgumentZeroState argumentZeroState = new ArgumentZeroState();
    private ArgumentNumberState argumentNumberState = new ArgumentNumberState();
    private ArgumentDollarState argumentDollarState = new ArgumentDollarState();
    private ArgumentHexadecimalState argumentHexadecimalState = new ArgumentHexadecimalState();
    private ArgumentBinaryState argumentBinaryState = new ArgumentBinaryState();
    private ArgumentOperatorState argumentOperatorState = new ArgumentOperatorState();
    private ArgumentOperatorAnnotationState argumentOperatorAnnotationState = new ArgumentOperatorAnnotationState();
    private ArgumentLessThanState argumentLessThanState = new ArgumentLessThanState();
    private ArgumentGreaterThanState argumentGreaterThanState = new ArgumentGreaterThanState();
    private ArgumentShiftRightState argumentShiftRightState = new ArgumentShiftRightState();
    private ArgumentNotEqualsState argumentNotEqualsState = new ArgumentNotEqualsState();
    private ArgumentNotEqualsAnnotationState argumentNotEqualsAnnotationState = new ArgumentNotEqualsAnnotationState();
    private ArgumentAndState argumentAndState = new ArgumentAndState();
    private ArgumentOrState argumentOrState = new ArgumentOrState();
    private CommentReadState commentReadState = new CommentReadState();
    private CommentReadThenArgumentState commentReadThenArgumentState = new CommentReadThenArgumentState();
    private CommentReadThenOperatorState commentReadThenOperatorState = new CommentReadThenOperatorState();

    public Parser(SourceFile sourceFile) {
        this.reader = sourceFile.getReader();
        this.state = this.labelStartState;
    }

    public SourceFile getSourceFile() {
        return this.reader.getSourceFile();
    }

    public Line parse(Scope scope) {
        this.scope = scope;
        this.lineScope = new Scope(scope);
        SourceFile.SourceFileSpan span = null;
        int column = 0;
        try {
            do {
                span = this.reader.getSpan(span);
                String sourceLine = this.reader.readLine();
                if (sourceLine == null) {
                    this.state = this.state.parse('\u0000');
                    if (this.state != this.labelStartState) {
                        throw new AssemblyException("Unexpected end of file.");
                    }
                    if (!this.lineBuilder.isEmpty()) break;
                    this.lineBuilder.setMnemonic("END");
                    break;
                }
                column = 0;
                int i = 0;
                int length = sourceLine.length();
                while (i < length) {
                    column = i;
                    this.state = this.state.parse(sourceLine.charAt(i));
                    ++i;
                }
                column = sourceLine.length();
                this.state = this.state.parse('\n');
            } while (this.state != this.labelStartState || this.lineBuilder.isEmpty());
            if (this.accumulator.length() > 0) {
                throw new AssemblyException("Accumulator not consumed. Value: " + this.accumulator.toString());
            }
        }
        catch (AssemblyException e) {
            e.addContext(span.atColumn(column));
            throw e;
        }
        return this.lineBuilder.getLine(this.lineScope, span);
    }

    void skipToArgumentStartState(String mnemonic) {
        this.lineBuilder.setMnemonic(mnemonic);
        this.state = this.argumentStartState;
    }

    private static int parseInt(String string, int radix) {
        try {
            long value = Long.parseLong(string, radix);
            if (value > 0xFFFFFFFFL) {
                throw new SyntaxError();
            }
            return (int)value;
        }
        catch (NumberFormatException e) {
            throw new SyntaxError();
        }
    }

    private class ArgumentAndState
    extends State {
        private ArgumentAndState() {
        }

        @Override
        public State parse(char character) {
            if (character == '&') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.LOGICAL_AND);
                return Parser.this.argumentValueState;
            }
            Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.AND);
            return Parser.this.argumentValueState.parse(character);
        }
    }

    private class ArgumentBinaryState
    extends State {
        private ArgumentBinaryState() {
        }

        @Override
        public State parse(char character) {
            if (character >= '0' && character <= '1') {
                Parser.this.accumulator.append(character);
                return Parser.this.argumentBinaryState;
            }
            int value = Parser.parseInt(Parser.this.accumulator.toString(), 2);
            Parser.this.expressionBuilder.addValueToken(IntegerLiteral.of(value));
            Parser.this.accumulator.setLength(0);
            return Parser.this.argumentOperatorState.parse(character);
        }
    }

    private class ArgumentCharacterDoubleQuoteState
    extends State {
        private ArgumentCharacterDoubleQuoteState() {
        }

        @Override
        public State parse(char character) {
            if (character == '\'') {
                Parser.this.accumulator.append(character);
                return Parser.this.argumentCharacterEndState;
            }
            throw new SyntaxError();
        }
    }

    private class ArgumentCharacterEndState
    extends State {
        private ArgumentCharacterEndState() {
        }

        @Override
        public State parse(char character) {
            if (character == '\'') {
                Parser.this.expressionBuilder.addValueToken(new CharacterLiteral(Parser.this.accumulator.charAt(0)));
                Parser.this.accumulator.setLength(0);
                return Parser.this.argumentOperatorState;
            }
            throw new SyntaxError();
        }
    }

    private class ArgumentCharacterEscapeState
    extends State {
        private ArgumentCharacterEscapeState() {
        }

        @Override
        public State parse(char character) {
            State state = Parser.this.argumentStringEscapeState.parse(character);
            if (state == Parser.this.argumentStringState) {
                return Parser.this.argumentCharacterEndState;
            }
            throw new AssemblyException("Unexpected state.");
        }
    }

    private class ArgumentCharacterState
    extends State {
        private ArgumentCharacterState() {
        }

        @Override
        public State parse(char character) {
            if (character == '\'') {
                return Parser.this.argumentCharacterDoubleQuoteState;
            }
            if (character == '\\') {
                return Parser.this.argumentCharacterEscapeState;
            }
            if (character == '\n' || character == '\u0000') {
                throw new SyntaxError();
            }
            Parser.this.accumulator.append(character);
            return Parser.this.argumentCharacterEndState;
        }
    }

    private class ArgumentDollarState
    extends State {
        private ArgumentDollarState() {
        }

        @Override
        public State parse(char character) {
            if (character >= '0' && character <= '9' || character >= 'A' && character <= 'F' || character >= 'a' && character <= 'f') {
                Parser.this.accumulator.append(character);
                return Parser.this.argumentHexadecimalState;
            }
            Parser.this.expressionBuilder.addValueToken(new ContextLiteral(Parser.this.lineScope));
            Parser.this.accumulator.setLength(0);
            return Parser.this.argumentOperatorState.parse(character);
        }
    }

    private class ArgumentGreaterThanState
    extends State {
        private ArgumentGreaterThanState() {
        }

        @Override
        public State parse(char character) {
            if (character == '>') {
                return Parser.this.argumentShiftRightState;
            }
            if (character == '=') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.GREATER_OR_EQUALS);
                return Parser.this.argumentValueState;
            }
            Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.GREATER_THAN);
            return Parser.this.argumentValueState.parse(character);
        }
    }

    private class ArgumentHexadecimalState
    extends State {
        private ArgumentHexadecimalState() {
        }

        @Override
        public State parse(char character) {
            if (character >= '0' && character <= '9' || character >= 'A' && character <= 'F' || character >= 'a' && character <= 'f') {
                Parser.this.accumulator.append(character);
                return Parser.this.argumentHexadecimalState;
            }
            int value = Parser.parseInt(Parser.this.accumulator.toString(), 16);
            Parser.this.expressionBuilder.addValueToken(IntegerLiteral.of(value));
            Parser.this.accumulator.setLength(0);
            return Parser.this.argumentOperatorState.parse(character);
        }
    }

    private class ArgumentIdentifierState
    extends State {
        private ArgumentIdentifierState() {
        }

        @Override
        public State parse(char character) {
            if (this.isIdentifier(character)) {
                Parser.this.accumulator.append(character);
                return Parser.this.argumentIdentifierState;
            }
            Parser.this.expressionBuilder.addValueToken(new Identifier(Parser.this.accumulator.toString(), Parser.this.scope));
            Parser.this.accumulator.setLength(0);
            return Parser.this.argumentOperatorState.parse(character);
        }
    }

    private class ArgumentLessThanState
    extends State {
        private ArgumentLessThanState() {
        }

        @Override
        public State parse(char character) {
            if (character == '<') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.SHIFT_LEFT);
                return Parser.this.argumentValueState;
            }
            if (character == '=') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.LESS_OR_EQUALS);
                return Parser.this.argumentValueState;
            }
            Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.LESS_THAN);
            return Parser.this.argumentValueState.parse(character);
        }
    }

    private class ArgumentNotEqualsAnnotationState
    extends State {
        private ArgumentNotEqualsAnnotationState() {
        }

        @Override
        public State parse(char character) {
            if (character == '=') {
                return Parser.this.argumentNotEqualsState.parse(character);
            }
            Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.ANNOTATION);
            Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.NOT);
            return Parser.this.argumentValueState.parse(character);
        }
    }

    private class ArgumentNotEqualsState
    extends State {
        private ArgumentNotEqualsState() {
        }

        @Override
        public State parse(char character) {
            if (character == '=') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.NOT_EQUALS);
                return Parser.this.argumentValueState;
            }
            throw new SyntaxError();
        }
    }

    private class ArgumentNumberState
    extends State {
        private ArgumentNumberState() {
        }

        @Override
        public State parse(char character) {
            if (character >= '0' && character <= '9' || character >= 'A' && character <= 'F' || character >= 'a' && character <= 'f') {
                Parser.this.accumulator.append(character);
                return Parser.this.argumentNumberState;
            }
            String string = Parser.this.accumulator.toString();
            if (character == 'H' || character == 'h') {
                int value = Parser.parseInt(string, 16);
                Parser.this.expressionBuilder.addValueToken(IntegerLiteral.of(value));
                Parser.this.accumulator.setLength(0);
                return Parser.this.argumentOperatorState;
            }
            if (character == 'O' || character == 'o') {
                int value = Parser.parseInt(string, 8);
                Parser.this.expressionBuilder.addValueToken(IntegerLiteral.of(value));
                Parser.this.accumulator.setLength(0);
                return Parser.this.argumentOperatorState;
            }
            if (string.endsWith("B") || string.endsWith("b")) {
                int value = Parser.parseInt(string.substring(0, string.length() - 1), 2);
                Parser.this.expressionBuilder.addValueToken(IntegerLiteral.of(value));
                Parser.this.accumulator.setLength(0);
            } else {
                int value = Parser.parseInt(string, 10);
                Parser.this.expressionBuilder.addValueToken(IntegerLiteral.of(value));
                Parser.this.accumulator.setLength(0);
            }
            return Parser.this.argumentOperatorState.parse(character);
        }
    }

    private class ArgumentOperatorAnnotationState
    extends State {
        private ArgumentOperatorAnnotationState() {
        }

        @Override
        public State parse(char character) {
            if (character == '!') {
                return Parser.this.argumentNotEqualsAnnotationState;
            }
            State state = Parser.this.argumentOperatorState.tryParse(character);
            if (state != null) {
                return state;
            }
            Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.ANNOTATION);
            return Parser.this.argumentValueState.parse(character);
        }
    }

    private class ArgumentOperatorState
    extends State {
        private ArgumentOperatorState() {
        }

        @Override
        public State parse(char character) {
            State state = this.tryParse(character);
            if (state != null) {
                return state;
            }
            throw new SyntaxError();
        }

        public State tryParse(char character) {
            if (character == ')') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.GROUP_CLOSE);
                return Parser.this.argumentOperatorState;
            }
            if (character == '[') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.INDEX_OPEN);
                return Parser.this.argumentValueState;
            }
            if (character == ']') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.INDEX_CLOSE);
                return Parser.this.argumentOperatorState;
            }
            if (character == '.') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.MEMBER);
                return Parser.this.argumentValueState;
            }
            if (character == '*') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.MULTIPLY);
                return Parser.this.argumentValueState;
            }
            if (character == '/') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.DIVIDE);
                return Parser.this.argumentValueState;
            }
            if (character == '%') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.MODULO);
                return Parser.this.argumentValueState;
            }
            if (character == '+') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.ADD);
                return Parser.this.argumentValueState;
            }
            if (character == '-') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.SUBTRACT);
                return Parser.this.argumentValueState;
            }
            if (character == '<') {
                return Parser.this.argumentLessThanState;
            }
            if (character == '>') {
                return Parser.this.argumentGreaterThanState;
            }
            if (character == '=') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.EQUALS);
                return Parser.this.argumentValueState;
            }
            if (character == '!') {
                return Parser.this.argumentNotEqualsState;
            }
            if (character == '&') {
                return Parser.this.argumentAndState;
            }
            if (character == '^') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.XOR);
                return Parser.this.argumentValueState;
            }
            if (character == '|') {
                return Parser.this.argumentOrState;
            }
            if (character == '?') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.TERNARYIF);
                return Parser.this.argumentValueState;
            }
            if (character == ':') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.TERNARYELSE);
                return Parser.this.argumentValueState;
            }
            if (character == ',') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.SEQUENCE);
                return Parser.this.argumentValueState;
            }
            if (this.isWhitespace(character)) {
                return Parser.this.argumentOperatorAnnotationState;
            }
            if (character == ';') {
                return Parser.this.commentReadThenOperatorState;
            }
            if (character == '\n' || character == '\u0000') {
                if (!Parser.this.expressionBuilder.hasOpenGroup() || character == '\u0000') {
                    Parser.this.lineBuilder.setArguments(Parser.this.expressionBuilder.getExpression());
                    return Parser.this.labelStartState;
                }
                return Parser.this.argumentOperatorAnnotationState;
            }
            return null;
        }
    }

    private class ArgumentOrState
    extends State {
        private ArgumentOrState() {
        }

        @Override
        public State parse(char character) {
            if (character == '|') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.LOGICAL_OR);
                return Parser.this.argumentValueState;
            }
            Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.OR);
            return Parser.this.argumentValueState.parse(character);
        }
    }

    private class ArgumentShiftRightState
    extends State {
        private ArgumentShiftRightState() {
        }

        @Override
        public State parse(char character) {
            if (character == '>') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.SHIFT_RIGHT_UNSIGNED);
                return Parser.this.argumentValueState;
            }
            Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.SHIFT_RIGHT);
            return Parser.this.argumentValueState.parse(character);
        }
    }

    private class ArgumentStartState
    extends State {
        private ArgumentStartState() {
        }

        @Override
        public State parse(char character) {
            if (character == ';') {
                return Parser.this.commentReadState;
            }
            if (character == '\n' || character == '\u0000') {
                return Parser.this.labelStartState;
            }
            if (this.isWhitespace(character)) {
                return Parser.this.argumentStartState;
            }
            return Parser.this.argumentValueState.parse(character);
        }
    }

    private class ArgumentStringDoubleQuoteState
    extends State {
        private ArgumentStringDoubleQuoteState() {
        }

        @Override
        public State parse(char character) {
            if (character == '\"') {
                Parser.this.accumulator.append(character);
                return Parser.this.argumentStringState;
            }
            Parser.this.expressionBuilder.addValueToken(new StringLiteral(Parser.this.accumulator.toString()));
            Parser.this.accumulator.setLength(0);
            return Parser.this.argumentOperatorState.parse(character);
        }
    }

    private class ArgumentStringEscapeState
    extends State {
        private ArgumentStringEscapeState() {
        }

        @Override
        public State parse(char character) {
            if (character == '0') {
                Parser.this.accumulator.append('\u0000');
                return Parser.this.argumentStringState;
            }
            if (character == 'a') {
                Parser.this.accumulator.append('\u0007');
                return Parser.this.argumentStringState;
            }
            if (character == 't') {
                Parser.this.accumulator.append('\t');
                return Parser.this.argumentStringState;
            }
            if (character == 'n') {
                Parser.this.accumulator.append('\n');
                return Parser.this.argumentStringState;
            }
            if (character == 'f') {
                Parser.this.accumulator.append('\f');
                return Parser.this.argumentStringState;
            }
            if (character == 'r') {
                Parser.this.accumulator.append('\r');
                return Parser.this.argumentStringState;
            }
            if (character == 'e') {
                Parser.this.accumulator.append('\u001b');
                return Parser.this.argumentStringState;
            }
            if (character == '\"') {
                Parser.this.accumulator.append('\"');
                return Parser.this.argumentStringState;
            }
            if (character == '\'') {
                Parser.this.accumulator.append('\'');
                return Parser.this.argumentStringState;
            }
            if (character == '\\') {
                Parser.this.accumulator.append('\\');
                return Parser.this.argumentStringState;
            }
            if (character == '\n' || character == '\u0000') {
                throw new SyntaxError();
            }
            throw new SyntaxError();
        }
    }

    private class ArgumentStringState
    extends State {
        private ArgumentStringState() {
        }

        @Override
        public State parse(char character) {
            if (character == '\"') {
                return Parser.this.argumentStringDoubleQuoteState;
            }
            if (character == '\\') {
                return Parser.this.argumentStringEscapeState;
            }
            if (character == '\n' || character == '\u0000') {
                throw new SyntaxError();
            }
            Parser.this.accumulator.append(character);
            return Parser.this.argumentStringState;
        }
    }

    private class ArgumentValueState
    extends State {
        private ArgumentValueState() {
        }

        @Override
        public State parse(char character) {
            if (this.isIdentifierStart(character)) {
                Parser.this.accumulator.append(character);
                return Parser.this.argumentIdentifierState;
            }
            if (character == '0') {
                Parser.this.accumulator.append(character);
                return Parser.this.argumentZeroState;
            }
            if (character >= '1' && character <= '9') {
                Parser.this.accumulator.append(character);
                return Parser.this.argumentNumberState;
            }
            if (character == '#') {
                return Parser.this.argumentHexadecimalState;
            }
            if (character == '$') {
                return Parser.this.argumentDollarState;
            }
            if (character == '%') {
                return Parser.this.argumentBinaryState;
            }
            if (character == '\"') {
                return Parser.this.argumentStringState;
            }
            if (character == '\'') {
                return Parser.this.argumentCharacterState;
            }
            if (character == '+') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.POSITIVE);
                return Parser.this.argumentValueState;
            }
            if (character == '-') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.NEGATIVE);
                return Parser.this.argumentValueState;
            }
            if (character == '~') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.COMPLEMENT);
                return Parser.this.argumentValueState;
            }
            if (character == '!') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.NOT);
                return Parser.this.argumentValueState;
            }
            if (character == '(') {
                Parser.this.expressionBuilder.addOperatorToken(((Parser)Parser.this).expressionBuilder.GROUP_OPEN);
                return Parser.this.argumentValueState;
            }
            if (this.isWhitespace(character)) {
                return Parser.this.argumentValueState;
            }
            if (character == ';') {
                return Parser.this.commentReadThenArgumentState;
            }
            if (character == '\n') {
                return Parser.this.argumentValueState;
            }
            throw new SyntaxError();
        }
    }

    private class ArgumentZeroState
    extends State {
        private ArgumentZeroState() {
        }

        @Override
        public State parse(char character) {
            if (character == 'x' || character == 'X') {
                Parser.this.accumulator.setLength(0);
                return Parser.this.argumentHexadecimalState;
            }
            return Parser.this.argumentNumberState.parse(character);
        }
    }

    private class CommentReadState
    extends State {
        private CommentReadState() {
        }

        @Override
        public State parse(char character) {
            if (character == '\n' || character == '\u0000') {
                Parser.this.lineBuilder.setComment(Parser.this.accumulator.toString());
                Parser.this.accumulator.setLength(0);
                return Parser.this.labelStartState;
            }
            Parser.this.accumulator.append(character);
            return Parser.this.commentReadState;
        }
    }

    private class CommentReadThenArgumentState
    extends State {
        private CommentReadThenArgumentState() {
        }

        @Override
        public State parse(char character) {
            if (character == '\n' || character == '\u0000') {
                Parser.this.lineBuilder.setComment(Parser.this.accumulator.toString());
                Parser.this.accumulator.setLength(0);
                return Parser.this.argumentValueState.parse(character);
            }
            Parser.this.accumulator.append(character);
            return Parser.this.commentReadThenArgumentState;
        }
    }

    private class CommentReadThenOperatorState
    extends State {
        private CommentReadThenOperatorState() {
        }

        @Override
        public State parse(char character) {
            if (character == '\n' || character == '\u0000') {
                Parser.this.lineBuilder.setComment(Parser.this.accumulator.toString());
                Parser.this.accumulator.setLength(0);
                return Parser.this.argumentOperatorState.parse(character);
            }
            Parser.this.accumulator.append(character);
            return Parser.this.commentReadThenOperatorState;
        }
    }

    private class LabelReadState
    extends State {
        private LabelReadState() {
        }

        @Override
        public State parse(char character) {
            if (this.isIdentifier(character)) {
                Parser.this.accumulator.append(character);
                return Parser.this.labelReadState;
            }
            Parser.this.lineBuilder.setLabel(Parser.this.accumulator.toString());
            Parser.this.accumulator.setLength(0);
            if (character == ':' || this.isWhitespace(character)) {
                return Parser.this.statementStartState;
            }
            if (character == ';') {
                return Parser.this.commentReadState;
            }
            if (character == '\n' || character == '\u0000') {
                return Parser.this.labelStartState;
            }
            throw new SyntaxError();
        }
    }

    private class LabelStartState
    extends State {
        private LabelStartState() {
        }

        @Override
        public State parse(char character) {
            if (this.isIdentifierStart(character)) {
                Parser.this.accumulator.append(character);
                return Parser.this.labelReadState;
            }
            if (this.isWhitespace(character)) {
                return Parser.this.statementStartState;
            }
            if (character == ';') {
                return Parser.this.commentReadState;
            }
            if (character == '\n' || character == '\u0000') {
                return Parser.this.labelStartState;
            }
            throw new SyntaxError();
        }
    }

    private abstract class State {
        private State() {
        }

        public abstract State parse(char var1);

        public boolean isWhitespace(char character) {
            return character == ' ' || character == '\t';
        }

        public boolean isIdentifier(char character) {
            return this.isIdentifierStart(character) || character >= '0' && character <= '9' || character == '\'' || character == '$';
        }

        public boolean isIdentifierStart(char character) {
            return character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || character == '_' || character == '.' || character == '?' || character == '@';
        }
    }

    private class StatementReadState
    extends State {
        private StatementReadState() {
        }

        @Override
        public State parse(char character) {
            if (this.isIdentifier(character)) {
                Parser.this.accumulator.append(character);
                return Parser.this.statementReadState;
            }
            if (character == ':') {
                Parser.this.lineBuilder.setLabel(Parser.this.accumulator.toString());
                Parser.this.accumulator.setLength(0);
                return Parser.this.statementStartState;
            }
            Parser.this.lineBuilder.setMnemonic(Parser.this.accumulator.toString());
            Parser.this.accumulator.setLength(0);
            if (this.isWhitespace(character)) {
                return Parser.this.argumentStartState;
            }
            if (character == ';') {
                return Parser.this.commentReadState;
            }
            if (character == '\n' || character == '\u0000') {
                return Parser.this.labelStartState;
            }
            throw new SyntaxError();
        }
    }

    private class StatementStartState
    extends State {
        private StatementStartState() {
        }

        @Override
        public State parse(char character) {
            if (this.isIdentifierStart(character)) {
                Parser.this.accumulator.append(character);
                return Parser.this.statementReadState;
            }
            if (this.isWhitespace(character)) {
                return Parser.this.statementStartState;
            }
            if (character == ';') {
                return Parser.this.commentReadState;
            }
            if (character == '\n' || character == '\u0000') {
                return Parser.this.labelStartState;
            }
            throw new SyntaxError();
        }
    }

    public static class SyntaxError
    extends AssemblyException {
        private static final long serialVersionUID = 1L;

        public SyntaxError() {
            this((Throwable)null);
        }

        public SyntaxError(Throwable cause) {
            super("Syntax error.", cause);
        }
    }
}

